/* ***************************************************************************************
* FILE:          CloseOnTouchSession.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CloseOnTouchSession.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CLOSEONTOUCHSESSION_H
#define CLOSEONTOUCHSESSION_H

#include "lint_deactivation.h"
#include "View/CGI/TouchHandling/TouchSession.h"
#include "Courier/Visualization/ViewId.h"
#include <vector>

namespace hmibase {
namespace input {
class CloseOnTouchSession: public TouchSession
{
      typedef TouchSession Base;
   public:
      CloseOnTouchSession() {};
      virtual ~CloseOnTouchSession() {};

      virtual bool ProcessMessage(const Courier::Message& msg);

      virtual bool OnMessage(const Courier::TouchMsg* touchMsgPtr);

      bool IsTouchOnPopupSurface(Courier::UInt32 const surfaceId) const;

      void updateCloseOnExternalTouch(bool const status);

   private:
      std::vector<Courier::ViewId> mRegisteredScenes;
      //Counter to know how many popups have close on touch activated
      static unsigned int mCloseOnExternalTouchCounter;
};


}
}


#endif // CLOSEONTOUCHSESSION_H
