/* ***************************************************************************************
* FILE:          CanderaDefaults.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CanderaDefaults.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "CanderaDefaults.h"

#include <CanderaPlatform/Device/Common/Effects/BitmapBrush.h>

#include <hmi_trace_if.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_VIEW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/CanderaDefaults.cpp.trc.h"
#endif

#ifdef WIN32
#include <windows.h>
#endif


namespace hmibase {
namespace view {

#ifdef WIN32
bool CanderaDefaults::InitSCHost()
{
   const char* bitmapBrushDefaultFilter = getenv("CANDERA_BITMAP_BRUSH_DEFAULT_FILTER");
   if (bitmapBrushDefaultFilter != NULL)
   {
      if (strcmp(bitmapBrushDefaultFilter, "NearestFilter") == 0)
      {
         SetBitmapBrushFilter(NearestFilter);
      }
      else if (strcmp(bitmapBrushDefaultFilter, "BilinearFilter") == 0)
      {
         SetBitmapBrushFilter(BilinearFilter);
      }
      else if (strcmp(bitmapBrushDefaultFilter, "AutomaticFilter") == 0)
      {
         SetBitmapBrushFilter(AutomaticFilter);
      }
      else
      {
         //nothing to do
      }
   }
   return true;
}


#endif

void CanderaDefaults::SetBitmapBrushFilter(Filter filter)
{
#ifdef CANDERA_CUSTOMIZATION_BITMAP_BRUSH
   switch (filter)
   {
      case BilinearFilter:
         Candera::BitmapBrush::DefaultFilter = Candera::RenderDevice2D::BilinearFilter;
         break;

      case NearestFilter:
         Candera::BitmapBrush::DefaultFilter = Candera::RenderDevice2D::NearestFilter;
         break;

      case AutomaticFilter:
         Candera::BitmapBrush::DefaultFilter = Candera::RenderDevice2D::AutomaticFilter;
         break;

      default:
         break;
   }
#else
   (void)filter;

   _TODO("Customizations for BitmapBrush are not available. Most likely the git commits from ai_cgi_delivery are not in your branch.")
   ETG_TRACE_FATAL_THR(("Default BitmapBrushFilter can not be set because the customizations for BitmapBrush are not available. Most likely the git commits from ai_cgi_delivery are not in your branch."));
#endif
}


}
}
