/* ***************************************************************************************
* FILE:          BoschCustomDiagnostic.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BoschCustomDiagnostic.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(__BoschCustomDiagnostic_h_)
#define __BoschCustomDiagnostic_h_

// BoschCustomDiagnostic.h only for target systems
#ifdef __cplusplus

#ifdef WIN32 // macro to prevent lint warnings for false==false : should be adapt from Feat
#define FEATSTD_DEBUG_ASSERT_ALWAYS() FEATSTD_DEBUG_ASSERT(false)
#else

#include "hmibase/util/Assert.h"

#if defined(FEATSTD_DEBUG)
#define FEATSTD_DEBUG_BREAK()  \
         hmibase::util::Assert("CGI::FEATSTD_DEBUG_BREAK->abort",__FILE__,__LINE__);

#define FEATSTD_DEBUG_ASSERT(condition)  \
         if ((condition) == false) { hmibase::util::Assert((#condition),__FILE__, __LINE__); }

#define FEATSTD_DEBUG_ASSERT_ALWAYS()  \
         hmibase::util::Assert("CGI::FEATSTD_DEBUG_ASSERT_ALWAYS",__FILE__, __LINE__);

#define FEATSTD_DEBUG_FAIL()  \
         hmibase::util::Assert("CGI::DEBUG_FAIL->abort",__FILE__,__LINE__);
#else
#define FEATSTD_DEBUG_BREAK()
#define FEATSTD_DEBUG_ASSERT(condition)
#define FEATSTD_DEBUG_ASSERT_ALWAYS()
#define FEATSTD_DEBUG_FAIL()
#endif

#define FEATSTD_OS_BREAK()  \
         hmibase::util::Assert("CGI::FEATSTD_OS_BREAK->abort",__FILE__,__LINE__);



#endif // GEN3ARM ...

#endif // __cplusplus

#endif   // include guard
