/* ***************************************************************************************
* FILE:          AttachedAnimation.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AttachedAnimation.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(_HMIBASE_ATTACHED_ANIMATION_H_)
#define _HMIBASE_ATTACHED_ANIMATION_H_

#include "ViewControllerBase.h"

namespace Candera {
class CanderaObject;
class GraphicDeviceUnit;
}


namespace Courier {
class AnimationIndMsg;
class AnimationProperties;
class Message;
}


namespace hmibase {
namespace view {

class ViewAccessor;
class ViewControllerBase;

/************************************************************************/
/** Starts or stops an attached animation for the active view.
 * The main camera of the active view is temporary attached to a framebuffer used as texture in a dedicated view called attached view.
 * The animation animates nodes in this attached view.
 */
class AttachedAnimationMessageHandler : public ViewControllerBase::MessageHandler
{
   public:
      /************************************************************************/
      AttachedAnimationMessageHandler(const FeatStd::Char* defaultAttachedViewName, const FeatStd::Char* textureRTNodeName, const FeatStd::Char* defaultAnimationName = "");
      virtual ~AttachedAnimationMessageHandler();

      /************************************************************************/
      const Courier::ViewId& GetDefaultAttachedViewId() const;
      const FeatStd::Char* GetTextureRTNodeName() const;
      const Courier::ItemId& GetDefaultAnimationId() const;

      bool IsAutoStartEnabled() const;
      void SetAutoStart(bool enable);

      /************************************************************************/
      virtual bool OnMessage(ViewControllerBase& viewController, const Courier::Message& msg) override;

      virtual void OnViewActivate(ViewControllerBase& viewController, bool activate);
      virtual bool OnAttachedAnimationReqMsg(ViewControllerBase& viewController, const AttachedAnimationReqMsg& msg);
      virtual bool OnAnimationIndMsg(ViewControllerBase& viewController, const Courier::AnimationIndMsg& msg);

      /************************************************************************/
      virtual void OnAnimationEnded(ViewControllerBase& viewController, const Courier::ItemId& animationId);
      virtual bool StartAnimation(ViewControllerBase& viewController, const Courier::ViewId& attachedViewId, const FeatStd::String& textureRTNodeName, const Courier::ItemId& animationId, const Courier::AnimationProperties& animationProperties);

   protected:
      /************************************************************************/
      virtual Candera::GraphicDeviceUnit* FindTextureRT(ViewAccessor& attachedViewAccessor, const FeatStd::String& textureRTNodeName);
      virtual Candera::CanderaObject* FindCamera(ViewAccessor& activeViewAccessor);

      virtual bool PrepareCamera(ViewAccessor& attachedViewAccessor, const FeatStd::String& textureRTNodeName, ViewAccessor& activeViewAccessor);
      virtual bool RestoreCamera(ViewAccessor& attachedViewAccessor, ViewAccessor& activeViewAccessor);

      /************************************************************************/
      Courier::ViewId _defaultAttachedViewId;
      std::string _textureRTNodeName;
      Courier::ItemId _defaultAnimationId;
      bool _autoStart;

      Courier::ViewId _attachedViewId;
      Courier::ItemId _animationId;
      FeatStd::Optional<Candera::GraphicDeviceUnit*> _cameraRestoreInfo;
};


}
}


#endif
