/* ***************************************************************************************
* FILE:          AssetCustomIdValidator.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AssetCustomIdValidator is part of HMI-Base Framework
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef __HMIBASE_ASSET_CUSTOM_ID_VALIDATOR__
#define __HMIBASE_ASSET_CUSTOM_ID_VALIDATOR__

#include <FeatStd/Event/EventListener.h>

namespace hmibase {
namespace util {


/************************************************************************/
/** Validates asset repositories (partitions) based on the custom id (long value) stored in the asset header.
 * Set environment variable HMIBASE_BASSET_DEFAULT_CUSTOM_ID before generating the asset using BAsset tool in order to have the custom id stored into the asset. Read BAsset readme.txt for more details.
 * Call Register on a validator object before the asset partitions are being loaded.
 * When asset partitions are loaded the custom id stored into their header is compared with the one configured for the validator (if it is not zero).
 * In case of mismatch an error message or an assert is triggered depending on the AssertEnabled property of the validator.
 */
class AssetCustomIdValidator : public FeatStd::EventListener
{
   public:
      AssetCustomIdValidator(FeatStd::Int64 customId = 0LL, bool assertEnabled = false);
      virtual ~AssetCustomIdValidator();

      virtual FeatStd::EventResult::Enum OnEvent(const FeatStd::Event& e) override;

      void Register();
      void Unregister();

      void SetCustomId(FeatStd::Int64 customId);
      FeatStd::Int64 GetCustomId() const
      {
         return _customId;
      }

      void SetAssertEnabled(bool enable);
      bool IsAssertEnabled() const
      {
         return _assertEnabled;
      }

   protected:
      FeatStd::Int64 _customId;
      bool _assertEnabled;
};


}
}


#endif
