/* ***************************************************************************************
* FILE:          AppViewHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AppViewHandler.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef APPVIEWHANDLER_H
#define APPVIEWHANDLER_H

#include "Courier/Visualization/ViewHandler.h"
#include "Courier/Visualization/VisualizationMsgs.h"
#include "View/CGI/CgiExtensions/CourierMessageMapper.h"
#include "BaseContract/generated/BaseMsgs.h"
#include "MessageHandler.h"
#include "View/CGI/CgiExtensions/HMIRenderViewVisitor.h"
#include "ViewProfilehandler.h"
#include "View/CGI/CgiExtensions/RenderJobStrategy.h"
#include "View/CGI/CgiExtensions/Renderer.h"
#include "Gadget/SyncBlockProducerFactory.h"
#include "hmibase/util/Macros.h"

namespace hmibase {
namespace input {
class TouchSession;
}


}

class AppListDataProviderCache;

class AppViewHandler : public Courier::ViewHandler, public hmibase::view::RenderJobStrategy::RenderJobListener, public hmibase::view::IRenderObserver, public Courier::ViewVisitor
{
      typedef Courier::ViewHandler Base;

   public:

      virtual ~AppViewHandler();

      static AppViewHandler& getInstance()
      {
         static AppViewHandler _instance;
         return _instance;
      }

      virtual bool Init(Courier::ViewFactory* viewFactory, Candera::AssetConfig* assetConfiguration, Courier::Renderer* renderer, const Courier::Char* rootPath);

      void setBufferSwappingEnabled(bool enabled);
      bool isBufferSwappingEnabled() const;

      void registerMessageHandler(::hmibase::view::MessageHandler& handler);
      void unregisterMessageHandler(::hmibase::view::MessageHandler& handler);

      void RegisterViewVisitor(Courier::ViewVisitor& visitor);
      void DeregisterViewVisitor(Courier::ViewVisitor& visitor);

      void SetTouchSession(::hmibase::input::TouchSession* touchSession);
      ::hmibase::input::TouchSession* GetTouchSession() const
      {
         return _touchSession;
      }

      COURIER_MSG_MAP_BEGIN(TR_CLASS_HMI_FW)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(Courier::ActivationResMsg)
      ON_COURIER_MESSAGE(Courier::ViewRenderingResMsg)
      ON_COURIER_MESSAGE(Courier::SetCultureResMsg)
      ON_COURIER_MESSAGE(LocalizationReqMsg)
      ON_COURIER_MESSAGE(PopupReqMsg)
      ON_COURIER_MESSAGE(ApplicationStateUpdMsg)
      ON_COURIER_MESSAGE(SurfaceStateChangedUpdMsg)
      ON_COURIER_MESSAGE(SbAnimationStateChangedUpdMsg)
      ON_COURIER_MESSAGE(SBPopupTimerExpiryUpdMsg)
      ON_COURIER_MESSAGE(EglWaitNativeReqMsg)
      ON_COURIER_MESSAGE(hmibase::gadget::PositionInfoReqMsg)
      ON_COURIER_MESSAGE(ResetGadgetCacheReqMsg)
      ON_COURIER_MESSAGE(hmibase::gadget::ConsumerMsg)
      ON_COURIER_MESSAGE(CreateNewDestroyOld)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      //      COURIER_MSG_MAP_NOTCONSUMED_DELEGATE_BEGIN()
      COURIER_MSG_DELEGATE_TO_FKT(dispatchToMessageHandlers)
      COURIER_MSG_DELEGATE_TO_OBJ(_viewprofilehandler)
      COURIER_MSG_DELEGATE_TO_CLASS(Courier::ViewHandler)
      COURIER_MSG_DELEGATE_TO_REF(hmibase::gadget::SyncBlockProducerFactory::GetInstance())
      //      COURIER_MSG_MAP_NOTCONSUMED_DELEGATE_ENDS()
      COURIER_MSG_MAP_ENDS()

      virtual Courier::FrameworkWidget* FindWidget(const Courier::ViewId& viewId, const Courier::CompositePath& compositePath, const Courier::ItemId& widgetId);
      virtual Candera::WidgetBase* FindWidget(const Courier::ViewId& viewId, const Courier::Identifier& widgetId);

      virtual bool OnMessageViewTreeOnly(const Courier::Message& msg);

      virtual bool SetFocus(const Courier::ViewId& viewId,

                            const Courier::CompositePath& compositePath,

                            const Courier::ItemId& widgetId);

      virtual bool LoseFocus(Courier::FrameworkWidget* widget);

      virtual void onPreRender();
      virtual void onPostRender(bool continousExecutionEnabled);

      virtual bool ActivateLayer(Courier::Int layerId, bool activate);

      void enableDirectApplicationActivation(bool status)
      {
         _isDirectApplicationActivationEnabled = status;
      }

      const ::hmibase::view::HMIRenderViewVisitor& getRenderViewVisitor()
      {
         return _HMIRenderViewVisitor;
      }

      void setArabicLayoutPatch(bool flag, bool invalidateViews = true);

      virtual void OnPostSwapBuffer(Courier::Gdu& gdu);

      // Courier::ViewVisitor
      bool OnBegin();
      virtual bool Visit(Courier::ViewContainer* viewContainer);
#if defined(CANDERA_2D_ENABLED)
      virtual void Visit(Courier::ViewScene2D* view);
#endif
#if defined(CANDERA_3D_ENABLED)
      virtual void Visit(Courier::ViewScene3D* view);
#endif
      virtual void OnEnd();
      //

   private:

      typedef enum
      {
         EN_IDLE,
         EN_ON_RENDER_CALLBACK,
         EN_ON_SURFACE_AVAILABILITY,
         EN_ON_UNBLOCKED
      } ScreenBrokerSHowRequestState;

      typedef struct
      {
         Courier::UInt32 displayID;
         Courier::UInt32 surfaceID;
         ScreenBrokerSHowRequestState SBShowRequestState;
      } AppstateDisplayReq;

      AppViewHandler();

      bool onCourierMessage(const Courier::StartupMsg& msg);
      bool onCourierMessage(const Courier::SetCultureResMsg& oMsg);
      bool onCourierMessage(const LocalizationReqMsg& msg);
      bool onCourierMessage(const PopupReqMsg& msg);
      bool onCourierMessage(const ApplicationStateUpdMsg& msg);
      bool onCourierMessage(const SurfaceStateChangedUpdMsg& msg);
      bool onCourierMessage(const Courier::ActivationResMsg& msg);
      bool onCourierMessage(const Courier::ViewRenderingResMsg& msg);
      bool onCourierMessage(const SbAnimationStateChangedUpdMsg& msg);
      bool onCourierMessage(const SBPopupTimerExpiryUpdMsg& msg);
      bool onCourierMessage(const EglWaitNativeReqMsg& msg);
      bool onCourierMessage(const hmibase::gadget::PositionInfoReqMsg& msg);
      bool onCourierMessage(const ResetGadgetCacheReqMsg& msg);
      bool onCourierMessage(const hmibase::gadget::ConsumerMsg& msg);
      bool onCourierMessage(const CreateNewDestroyOld& msg);

      bool dispatchToMessageHandlers(const Courier::Message& msg);

      bool isViewOnSurface(unsigned int surfaceId) const;
      bool SendSBShowRequest(AppstateDisplayReq& appStateReq);
      void adjustNiceLevelOnApplicationStatus(hmibase::hmiappstates applicationState);

      FeatStd::String _currentFocusView;
      FeatStd::String _currentFocusWidget;

      bool _isDirectApplicationActivationEnabled;

      typedef std::vector< ::hmibase::view::MessageHandler* > MessageHandlersType;
      MessageHandlersType _messageHandlers;

      typedef std::set<Courier::ViewVisitor*> ViewVisitorsType;
      ViewVisitorsType _viewVisitors;

      ::hmibase::view::HMIRenderViewVisitor _HMIRenderViewVisitor;
      ::hmibase::view::ViewProfilehandler* _viewprofilehandler;
      ::hmibase::input::TouchSession* _touchSession;

      typedef std::vector<AppstateDisplayReq> AppstatDisplayReqType;
      AppstatDisplayReqType _appstateReqlist;
      void AddtoAppStateDisplayList(const Courier::UInt32 displayid, const Courier::UInt32 surfaceId, const ScreenBrokerSHowRequestState RequestState);
      void RemoveFromAppStateDisplayList();

      bool GetSurface(Courier::Gdu& gdu, uint32_t& surfaceId);

      void ProcessPendingSBShowRequests();

      HMIBASE_UNCOPYABLE(AppViewHandler)
};


#endif
