/* ***************************************************************************************
* FILE:          WidgetInstanceFinderCallback.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WidgetInstanceFinderCallback.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "sys_std_if.h"
#include "WidgetInstanceFinderCallback.h"
#include "CanderaWidget/Widget.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/WidgetInstanceFinderCallback.cpp.trc.h"
#endif


namespace hmibase {
namespace trace {
// ------------------------------------------------------------------------
WidgetInstanceFinderCallback::WidgetInstanceFinderCallback(const Candera::String& widgetName) :
   _widgetName(widgetName),
   _widget(0)
{
}


// ------------------------------------------------------------------------
bool WidgetInstanceFinderCallback::CheckWidget(Candera::Widget2D* widget)
{
   if (widget != NULL)
   {
      const FeatStd::Char* widgetName = widget->GetLegacyName();
      if (widgetName == 0)
      {
         widgetName = widget->GetName();
      }
      if (!strcmp(_widgetName.GetCString(), widgetName))
      {
         _widget = static_cast<Candera::WidgetBase*>(widget);
         return true;
      }
   }
   return false;
}


} // namespace trace
}
