/* ***************************************************************************************
* FILE:          TraceHelper.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TraceHelper.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "sys_std_if.h"
#include "TraceHelper.h"

#include "hmi_trace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/TraceHelper.cpp.trc.h"
#endif

namespace hmibase {
namespace trace {

void traceVarg(int traceLevel, int traceClass, char const* format, ...)
{
   if (etg_bIsTraceActive(traceClass, static_cast<etg_tU16>(traceLevel)))
   {
      va_list args;
      va_start(args, format);
      char text[255];
      vsnprintf(text, 255, format, args);
      text[254] = 0;
      va_end(args);
#ifdef _MSC_VER
      ETG_TRACE_USR1_CLS_THR((traceClass, "%s", text));
#else
      switch (traceClass)
      {
         case TR_CLASS_HMI_PERFORMANCE_MP:
            ETG_TRACE_LVL_CLS_THR((traceLevel, TR_CLASS_HMI_PERFORMANCE_MP, "%s", text));
            break;
         case TR_CLASS_HMI_CGI:
            ETG_TRACE_LVL_CLS_THR((traceLevel, TR_CLASS_HMI_CGI, "%s", text));
            break;
         case TR_CLASS_HMI_SM:
            ETG_TRACE_LVL_CLS_THR((traceLevel, TR_CLASS_HMI_SM, "%s", text));
            break;
         case TR_CLASS_HMI_FW:
            ETG_TRACE_LVL_CLS_THR((traceLevel, TR_CLASS_HMI_FW, "%s", text));
            break;
         case TR_CLASS_HMI_FW_VIEW:
            ETG_TRACE_LVL_CLS_THR((traceLevel, TR_CLASS_HMI_FW_VIEW, "%s", text));
            break;
         default:
         {
            ETG_TRACE_FATAL_CLS((TR_CLASS_HMI_FW, "ERROR: TraceHelper remapped unsupported trace class %d to TR_CLASS_HMI_FW", traceClass));
            ETG_TRACE_FATAL_CLS((TR_CLASS_HMI_FW, "%s", text));
         }
         break;
      }
#endif
   }
}


void traceVarg(int traceLevel, int traceClass, int dclTraceClass, char const* format, ...)
{
   if (etg_bIsTraceActiveDouble(((0xFFFFu & static_cast<etg_tU16>(traceClass)) << 16) | static_cast<etg_tU16>(traceLevel), static_cast<etg_tU16>(dclTraceClass)))
   {
      va_list args;
      va_start(args, format);
      char text[255];
      vsnprintf(text, 255, format, args);
      text[254] = 0;
      va_end(args);
#ifdef _MSC_VER
      ETG_TRACE_USR1_CLS_THR_DCL((traceClass, dclTraceClass, "%s", text));
#else
      switch (traceClass)
      {
         case TR_CLASS_HMI_PERFORMANCE_MP:
            ETG_TRACE_LVL_CLS_THR_DCL((traceLevel, TR_CLASS_HMI_PERFORMANCE_MP, dclTraceClass, "%s", text));
            break;
         case TR_CLASS_HMI_CGI:
            ETG_TRACE_LVL_CLS_THR_DCL((traceLevel, TR_CLASS_HMI_CGI, dclTraceClass, "%s", text));
            break;
         case TR_CLASS_HMI_SM:
            ETG_TRACE_LVL_CLS_THR_DCL((traceLevel, TR_CLASS_HMI_SM, dclTraceClass, "%s", text));
            break;
         case TR_CLASS_HMI_FW:
            ETG_TRACE_LVL_CLS_THR_DCL((traceLevel, TR_CLASS_HMI_FW, dclTraceClass, "%s", text));
            break;
         case TR_CLASS_HMI_FW_VIEW:
            ETG_TRACE_LVL_CLS_THR_DCL((traceLevel, TR_CLASS_HMI_FW_VIEW, dclTraceClass, "%s", text));
            break;
         default:
         {
            ETG_TRACE_FATAL_CLS((TR_CLASS_HMI_FW, "ERROR: TraceHelper remapped unsupported trace class %d to TR_CLASS_HMI_FW, dclTraceClass %d", traceClass, dclTraceClass));
            ETG_TRACE_FATAL_CLS((TR_CLASS_HMI_FW, "%s", text));
         }
         break;
      }
#endif
   }
}


}
}
