/* ***************************************************************************************
* FILE:          TTFisAppender.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TTFisAppender.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(TTFisAppender_h)
#define TTFisAppender_h

#include <FeatStd/Base.h>
#ifndef FEATSTD_LOG_ENABLED
#error Feature FEATSTD_ENABLE_LOG is not enabled. Do not include any FeatStd logging releated header files!
#endif

#include "hmibase/util/TraceUtils.h"
#include "FeatStd/Diagnostics/Appender.h"

namespace hmibase {
namespace trace {

class TTFisAppender : public FeatStd::Diagnostics::Appender
{
   public:
      TTFisAppender();
      virtual ~TTFisAppender();
      static TTFisAppender& GetInstance();
      void setTraceClasses(const sCGITraceGroup& traceIds);
   protected:
      virtual void DoAppend(const FeatStd::Diagnostics::LogEvent& logEvent);

   private:
      sCGITraceGroup _traceIds;
};


/// @}
}


}


#endif
