/* ***************************************************************************************
* FILE:          TTFisAppender.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TTFisAppender.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "sys_std_if.h"
#include "TTFisAppender.h"

#include <FeatStd/Util/StaticObject.h>
#include "FeatStd/Diagnostics/LogEvent.h"
//#include <FeatStd/Util/CharBuffer.h>
#include <FeatStd/Platform/Diagnostic.h>
#include <FeatStd/Diagnostics/Log.h>
//#include <FeatStd/Diagnostics/LogControl.h>
#include <Courier/Diagnostics/LogRealm.h>
#include <Courier/Diagnostics/TraceControl.h>
#include <Courier/Diagnostics/Log.h>
#include <Candera/System/Diagnostics/LogRealm.h>

#include "AppBase/IApplicationSettings.h"
#include "hmi_trace_if.h"


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_CGI
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/TTFisAppender.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

using FeatStd::Internal::CharBuffer;
using FeatStd::Internal::Diagnostic;

namespace hmibase {
namespace trace {

TTFisAppender::TTFisAppender() : _traceIds(0, 0, 0, 0, 0, 0, 0)
{
}


TTFisAppender::~TTFisAppender()
{
}


/******************************************************************************
 *  GetInstance
 ******************************************************************************/
TTFisAppender& TTFisAppender::GetInstance()
{
   FEATSTD_UNSYNCED_STATIC_OBJECT(TTFisAppender, s_instance);
   return s_instance;
}


void TTFisAppender::setTraceClasses(const sCGITraceGroup& traceIds)
{
   _traceIds = traceIds;
}


void TTFisAppender::DoAppend(const FeatStd::Diagnostics::LogEvent& logEvent)
{
   etg_tU16 level = 0;
   switch (logEvent.mLogLevel)
   {
      case FeatStd::Diagnostics::LogLevel::Debug:
      case FeatStd::Diagnostics::LogLevel::Info:
         level = static_cast<etg_tU16>(TR_LEVEL_USER_4);
         break;
      case FeatStd::Diagnostics::LogLevel::Warning:
         level = static_cast<etg_tU16>(TR_LEVEL_USER_1);
         break;
      case FeatStd::Diagnostics::LogLevel::Error:
         level = static_cast<etg_tU16>(TR_LEVEL_ERROR);
         break;
      case FeatStd::Diagnostics::LogLevel::Fatal:
         level = static_cast<etg_tU16>(TR_LEVEL_FATAL);
         break;
      default:
         return;
   }

   etg_tU16 traceClass = 0;
   if (etg_bIsTraceActive(_traceIds.traceClass_Debug, level))
   {
      traceClass = _traceIds.traceClass_Debug;
   }
   else if ((etg_bIsTraceActive(_traceIds.traceClass_DataBinding, level))  // TR_CLASSOFFSET_APPHMI_CGI_DATABINDING
            && (strcmp(logEvent.mLogRealmName, Courier::Diagnostics::LogRealm::DataBinding::Name()) == 0))
   {
      traceClass = _traceIds.traceClass_DataBinding;
   }
   else if ((etg_bIsTraceActive(_traceIds.traceClass_Messaging, level))   // TR_CLASSOFFSET_APPHMI_CGI_MESSAGING
            && (strcmp(logEvent.mLogRealmName, Courier::Diagnostics::LogRealm::Messaging::Name()) == 0))
   {
      traceClass = _traceIds.traceClass_Messaging;
   }
   else if ((etg_bIsTraceActive(_traceIds.traceClass_Visualization, level))   // TR_CLASSOFFSET_APPHMI_CGI_VISUALIZATION
            && (strcmp(logEvent.mLogRealmName, Courier::Diagnostics::LogRealm::Visualization::Name()) == 0))
   {
      traceClass = _traceIds.traceClass_Visualization;
   }
   /*
   else if ((etg_bIsTraceActive(_traceIds.traceClass_CanderaAsset, level)) // TR_CLASSOFFSET_APPHMI_CGI_CANDERAASSET)
      && (strcmp(logEvent.mLogRealmName, Courier::Diagnostics::LogRealm::CanderaAssetLoader::Name()) == 0))
   {
      traceClass = _traceIds.traceClass_CanderaAsset;
   }
   */

   // check for activated trace classes here as we have to format string before ETG macro due to parameter count limitation
   if ((traceClass > 0) && etg_bIsTraceActiveDouble(((0xFFFFu & (etg_tU16)(TR_CLASS_HMI_CGI)) << 16) | (etg_tU16)(level), (etg_tU16)traceClass))
   {
      std::stringstream ss;

      ss << "[";
      ss << hmibase::trace::getAppName().c_str();
      ss << "] ";
      ss << logEvent.mLogRealmName;
      ss << " {";
      ss << logEvent.mLocation.mFileName;
      ss << "(";
      ss << logEvent.mLocation.mLineNumber;
      ss << "): ";
      ss << logEvent.mLocation.mMethodName;
      ss << "} ";
      ss << logEvent.mMessage;

      size_t idx = 0;
      size_t length = ss.str().length();
      const size_t stepSize = ETG_C_TRACE_MAX - 20; // max length for TTFis traces, assuming a message header size of 20
      std::string identation = "\t-> ";
      size_t identationLength = identation.length();

      while (idx < length)
      {
         std::stringstream ss2;
         if (idx == 0)
         {
            ss2 << ss.str().substr(idx, stepSize);
            idx += stepSize;
         }
         else
         {
            ss2 << identation;
            ss2 << ss.str().substr(idx, stepSize);
            idx += stepSize - identationLength;
         }

         ETG_TRACE_LVL_THR_DCL((level, traceClass, "%s", ss2.str().c_str()));
      }
   }
}


}
}
