/* ***************************************************************************************
* FILE:          StartupInvestigation.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  StartupInvestigation.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef STARTUPINVESTIGATION_H
#define STARTUPINVESTIGATION_H

#include <AppUtils/HmiMacros.h>
#include <stdint.h>
#include <string>
#include <cstring>

#define HMI_STARTUP_INVESTIGATION(mp)     hmibase::trace::StartupInvestigation::s_getInstance().addTimestamp(static_cast<hmibase::trace::StartupInvestigation::MeasurePoints>(mp));

#define HMI_STARTUP_INVESTIGATION_WITH_TIMESTAMP(mp, timestamp)   hmibase::trace::StartupInvestigation::s_getInstance().addTimestamp(static_cast<hmibase::trace::StartupInvestigation::MeasurePoints>(mp), timestamp);

#define HMI_STARTUP_INVESTIGATION_POST(mp)    Courier::Message* msg = COURIER_MESSAGE_NEW(QueryTraceInfoReqMsg)(hmibase::ADD_STARTUP_INVESTIGATION, mp, hmibase::util::Ticker::getTickCountMsec(), 0, 0); \
                                                         if(msg != 0) \
                                                         { \
                                                            msg->PostToNextRecipient(); \
                                                         }
#define HMI_STARTUP_INVESTIGATION_WITH_TIMESTAMP_POST(mp, timestamp)    Courier::Message* msg = COURIER_MESSAGE_NEW(QueryTraceInfoReqMsg)(TraceQueryId::ADD_STARTUP_INVESTIGATION, mp, timestamp, 0, 0); \
                                                         if(msg != 0) \
                                                         { \
                                                            msg->PostToNextRecipient(); \
                                                         }


namespace hmibase {
namespace trace {

class StartupInvestigation
{
   public:
      enum MeasurePoints
      {
         MP_CONSTRUCTOR_GUI = 0u,
         MP_CONSTRUCTOR_HALL,
         MP_GUIFW_INIT_BEGIN,
         MP_GUIFW_INIT_END,
         MP_START_GUI_THREADS_BEGIN,
         MP_START_GUI_THREADS_END,
         MP_GUI_MAINLOOP_START,
         MP_COURIER_STARTUP_MESSAGE_RECEIVED,
         MP_FIRST_SCREEN_DRAWN_2D,
         MP_FIRST_SCREEN_DRAWN_3D,
         MP_LSM_INFO_AVAILABLE,
         MP_DISABLE_STARTUP_LOGO,
         MP_MAIN_SURFACE_FIRST_TIME_VISIBLE,
         MP_MAX
      };

      inline static StartupInvestigation& s_getInstance()
      {
         return *ms_theInstance;
      }

      inline static void s_initialize()
      {
         if (StartupInvestigation::ms_theInstance == 0)
         {
            ms_theInstance = new StartupInvestigation();
         }
         else
         {
            HMI_APP_ASSERT_ALWAYS();
         }
      }

      virtual ~StartupInvestigation()
      {
      }

      void addTimestamp(MeasurePoints mp);
      void addTimestamp(MeasurePoints mp, uint32_t timestamp);
      void print();

      uint32_t getTimestamp(MeasurePoints mp)
      {
         return m_aMeasurePoints[mp];
      }

   private:
      /** default constructor */
      StartupInvestigation();

      /** copy constructor */
      StartupInvestigation(const StartupInvestigation& /*rhs*/)
      {
         memset(m_aMeasurePoints, 0, static_cast<int>(MP_MAX) * sizeof(uint32_t));
      }

      /** assignment operator */
      StartupInvestigation& operator=(const StartupInvestigation& rhs);

      static StartupInvestigation* ms_theInstance;

      std::string m_appName;
      uint32_t m_aMeasurePoints[MP_MAX];
};


}
namespace utils {
namespace trace {
HMIBASE_DEPRECATED("Deprecated class hmibase::utils::trace::StartupInvestigation, please use hmibase::trace::StartupInvestigation instead", typedef ::hmibase::trace::StartupInvestigation StartupInvestigation);
}


}
}


#endif // STARTUPINVESTIGATION_H
