/* ***************************************************************************************
* FILE:          StartupInvestigation.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  StartupInvestigation.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "sys_std_if.h"
#include "StartupInvestigation.h"
#include "hmibase/util/Ticker.h"
#include "hmibase/util/TraceUtils.h"

#include "hmi_trace_if.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_PERFORMANCE_MP
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/StartupInvestigation.cpp.trc.h"
#endif

namespace hmibase {
namespace trace {

StartupInvestigation* StartupInvestigation::ms_theInstance = 0;

StartupInvestigation::StartupInvestigation()
{
   memset(m_aMeasurePoints, 0, static_cast<int>(MP_MAX) * sizeof(uint32_t));
}


void StartupInvestigation::addTimestamp(MeasurePoints mp)
{
   addTimestamp(mp, static_cast<uint32_t>(hmibase::util::Ticker::getTickCountMsec()));
}


void StartupInvestigation::addTimestamp(MeasurePoints mp, uint32_t timestamp)
{
   if (m_aMeasurePoints[mp] == 0)
   {
      m_aMeasurePoints[mp] = timestamp;
   }
   else
   {
      ETG_TRACE_FATAL_THR(("MeasurePoint %d already reached", ETG_CENUM(MeasurePoints, mp)));
   }
}


void StartupInvestigation::print()
{
   ETG_TRACE_FATAL_THR(("#### HMI Startup Investigation BEGIN ####"));
   for (uint32_t i = 0; i < static_cast<int>(MP_MAX); i++)
   {
      if (m_aMeasurePoints[i] != 0)
      {
         ETG_TRACE_FATAL_THR(("Startup investigation [%20s] %d: timestamp %u ms", hmibase::trace::getAppName().c_str(), ETG_CENUM(MeasurePoints, i), m_aMeasurePoints[i]));
      }
      else
      {
         ETG_TRACE_FATAL_THR(("Startup investigation [%20s] %d: no timestamp available ", hmibase::trace::getAppName().c_str(), ETG_CENUM(MeasurePoints, i)));
      }
   }
   ETG_TRACE_FATAL_THR(("#### HMI Startup Investigation END ####"));
}


}
}
