/* ***************************************************************************************
* FILE:          IOSExtensionsTpl.hp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IOSExtensionsTpl.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef _HMIBASE_IOS_EXTENSIONS_TPL_H_
#define _HMIBASE_IOS_EXTENSIONS_TPL_H_

#include <iosfwd>
#include "IOSExtensions.h"

/************************************************************************/
/* std                                                                  */
/************************************************************************/
#include <map>
#include <vector>

namespace std {
template <typename TKey, typename TVal>
::std::ostream& operator<<(::std::ostream& os, const map<TKey, TVal>& value)
{
   for (typename map<TKey, TVal> ::const_iterator it = value.begin(); it != value.end(); ++it)
   {
      if (it != value.begin())
      {
         os << ',';
      }
      os << it->first << ":[" << it->second << ']';
   }
   return os;
}


template <typename TVal>
::std::ostream& operator<<(::std::ostream& os, const vector<TVal>& value)
{
   for (typename vector<TVal> ::const_iterator it = value.begin(); it != value.end(); ++it)
   {
      if (it != value.begin())
      {
         os << ',';
      }
      os << '[' << *it << ']';
   }
   return os;
}


}

/************************************************************************/
/* Candera                                                              */
/************************************************************************/
#include <CanderaAssetLoader/AssetLoaderBase/ArrayProperty.h>

namespace Candera {
template <typename TVal>
::std::ostream& operator<<(::std::ostream& os, const ArrayProperty<TVal>& value)
{
   for (::FeatStd::UInt i = 0; i < value.GetCount(); ++i)
   {
      if (i != 0)
      {
         os << ',';
      }
      os << '[' << value.Get(i) << ']';
   }
   return os;
}


}

/************************************************************************/
/* FeatStd                                                              */
/************************************************************************/
#include <FeatStd/Container/Vector.h>
#include <FeatStd/MemoryManagement/SharedPointer.h>

namespace FeatStd {
namespace Internal {
template <typename TVal>
::std::ostream& operator<<(::std::ostream& os, const Vector<TVal>& value)
{
   for (::FeatStd::SizeType i = 0; i < value.Size(); ++i)
   {
      if (i != 0)
      {
         os << ',';
      }
      os << '[' << value[i] << ']';
   }
   return os;
}


}

namespace MemoryManagement {
template <typename TVal>
::std::ostream& operator<<(::std::ostream& os, const SharedPointer<TVal>& value)
{
   os << static_cast<const void*>(value.GetPointerToSharedInstance());
   if (!value.PointsToNull())
   {
      os << '.' << *value;
   }
   return os;
}


}
}


#endif
