/* ***************************************************************************************
* FILE:          IOSExtensions.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IOSExtensions.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef _HMIBASE_IOS_EXTENSIONS_H_
#define _HMIBASE_IOS_EXTENSIONS_H_

#include <iosfwd>

#define HMIBASE_STREAM_INSERTION_OP(T)\
   ::std::ostream& operator<<(::std::ostream& os, const T& value);

#define HMIBASE_STREAM_INSERTION_OP_CLASS(T)\
   class T;\
   HMIBASE_STREAM_INSERTION_OP(T)

#define HMIBASE_STREAM_INSERTION_OP_STRUCT(T)\
   struct T;\
   HMIBASE_STREAM_INSERTION_OP(T)

#define _HMIBASE_TO_STRING_NON_NULL(s) (((s) != NULL) ? (s) : "<null>")


//keep these lists clean and sorted!

namespace Candera {
HMIBASE_STREAM_INSERTION_OP_CLASS(Bitmap);
HMIBASE_STREAM_INSERTION_OP_CLASS(CanderaObject);
HMIBASE_STREAM_INSERTION_OP_CLASS(Color);
HMIBASE_STREAM_INSERTION_OP_CLASS(GraphicDeviceUnit);
HMIBASE_STREAM_INSERTION_OP_CLASS(Image2D);
HMIBASE_STREAM_INSERTION_OP_CLASS(Margin);
HMIBASE_STREAM_INSERTION_OP_CLASS(Matrix3);
HMIBASE_STREAM_INSERTION_OP_CLASS(Matrix3x2);
HMIBASE_STREAM_INSERTION_OP_CLASS(Matrix4);
HMIBASE_STREAM_INSERTION_OP_CLASS(Node);
HMIBASE_STREAM_INSERTION_OP_CLASS(Node2D);
HMIBASE_STREAM_INSERTION_OP_CLASS(Vector2);
HMIBASE_STREAM_INSERTION_OP_CLASS(Vector3);
HMIBASE_STREAM_INSERTION_OP_CLASS(Vector4);
HMIBASE_STREAM_INSERTION_OP_CLASS(Rectangle);
}


namespace Courier {
HMIBASE_STREAM_INSERTION_OP_CLASS(Identifier);
HMIBASE_STREAM_INSERTION_OP_CLASS(ItemId);
HMIBASE_STREAM_INSERTION_OP_CLASS(Message);
HMIBASE_STREAM_INSERTION_OP_STRUCT(TouchInfo);
HMIBASE_STREAM_INSERTION_OP_CLASS(View);
HMIBASE_STREAM_INSERTION_OP_CLASS(ViewId);
}


namespace FeatStd {
HMIBASE_STREAM_INSERTION_OP_CLASS(String);
}


namespace hmibase {
namespace input {
namespace gesture {
HMIBASE_STREAM_INSERTION_OP_STRUCT(GestureEvent);
}


}

namespace widget {
HMIBASE_STREAM_INSERTION_OP_CLASS(Widget);
}


namespace util {
namespace geometry {
HMIBASE_STREAM_INSERTION_OP_STRUCT(Point);
HMIBASE_STREAM_INSERTION_OP_STRUCT(Rect);
HMIBASE_STREAM_INSERTION_OP_STRUCT(Size);
}


}
}


#endif //  _HMIBASE_IOS_EXTENSIONS_H_
