/* ***************************************************************************************
* FILE:          GuiInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GuiInfo.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_UTILS_TRACE_GUI_INFO
#define HMIBASE_UTILS_TRACE_GUI_INFO


#include "AppUtils/HmiMacros.h"
#include "hmibase/util/Singleton.h"
#include "Courier/Platform/CriticalSection.h"

namespace Candera {
class Scene2D;
}


namespace Courier {
class IViewHandler;
}


namespace hmibase {
namespace trace {

class GuiInfo
{
      HMIBASE_UNCOPYABLE_CLASS(GuiInfo)

   public:
      static void setViewHandler(Courier::IViewHandler* viewHandler);
      static void printScene(Candera::Scene2D& scene);
      static void printScene(const char* sceneName);

   private:
      static Courier::IViewHandler* s_viewHandler;
      static Courier::Platform::CriticalSection  _critical;
};


}

namespace utils {
namespace trace {
HMIBASE_DEPRECATED("Deprecated class hmibase::utils::trace::GuiInfo, please use hmibase::trace::GuiInfo instead", typedef ::hmibase::trace::GuiInfo GuiInfo);
}


}
}


#endif //  HMIBASE_UTILS_TRACE_GUI_INFO
