/* ***************************************************************************************
* FILE:          GetViewMetaInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GetViewMetaInfo.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef _GetGetViewMetaInfo_H_
#define _GetGetViewMetaInfo_H_

#include <set>

#include "AppUtils/HmiMacros.h"

class TiXmlElement;

namespace hmibase {
namespace trace {

class GetViewMetaInfo : public ::hmibase::view::MessageHandler
{
   public:
      GetViewMetaInfo();
      virtual ~GetViewMetaInfo();

      virtual bool onCourierMessage(const CreateTextMetaDataCollectionReqMsg& msg);
      virtual bool onCourierMessage(const Courier::ActivationResMsg& msg);
      virtual bool onCourierMessage(const Courier::ViewResMsg& msg);
      virtual bool onCourierMessage(const TimerExpiredMsg& msg);
      virtual bool onCourierMessage(const DumpScreenReqMsg& msg);
      virtual bool onCourierMessage(const ManualSceneActionReqMsg& msg);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_HMI_FW)
      ON_COURIER_MESSAGE(CreateTextMetaDataCollectionReqMsg)
      ON_COURIER_MESSAGE(Courier::ActivationResMsg)
      ON_COURIER_MESSAGE(Courier::ViewResMsg)
      ON_COURIER_MESSAGE(TimerExpiredMsg)
      ON_COURIER_MESSAGE(DumpScreenReqMsg)
      ON_COURIER_MESSAGE(ManualSceneActionReqMsg)
      COURIER_MSG_MAP_END()
      bool onMessage(const Courier::Message& msg)
      {
         return OnMessage(msg);
      }
      bool onWidgetInfo(Candera::Widget2D* w);

      void setViewHandler(AppViewHandler* viewHandler);

   private:
      void printAllScenes();
      void setupSurface();
      bool sendPopupShowReqMsg(::Courier::ViewId const& viewId);
      bool sendPopupHideReqMsg(::Courier::ViewId const& viewId);

      bool nextScene(bool restart = false);
      void timerStart();
      void timerStop(bool deleteInstance = false);

      void switchToView(const char* view);
      void HideView(const char* view);
      size_t getScenes();
      bool isPopup(const char* view);
      bool isPopup(const ::hmibase::view::ViewIdentifier& viewId);
      bool isNotValid(const char* view);
      void dumpScreen(const char* name);
      void dumpSceneOnSurface(const char* name, unsigned int surface);

      AppViewHandler* _viewHandler;
      std::vector<std::string>  _sceneList;
      Courier::ViewId _lastReqViewId;
      std::string _lastReqViewStr;
      Courier::ViewId _lastActViewId;
      ::Util::Timer* _timer;
      std::vector<std::string>::iterator _it;

      bool _isViewIdRecordingRunning;
      bool _textMetaDataCollectionRunning;
      std::set<Courier::ViewId> _createdViewIds;

      std::vector<TiXmlElement> _scenes;

      unsigned int _sceneCounter;
      bool _placeHolderRequired;

      HMIBASE_UNCOPYABLE(GetViewMetaInfo)
};


}
}


#endif
