/* ***************************************************************************************
* FILE:          Framework_Trace.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Framework_Trace.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef FRAMEWORK_TRACE_H
#define FRAMEWORK_TRACE_H

#ifndef HMI_TRACE_IF_INCLUDED
#error "Please include hmi_trace_if.h only"
#endif

// Trace class offsets inside application, e.g.: TR_TTFIS_UI_APP_HMI_00
#define TR_CLASSOFFSET_APPHMI_MAIN              (0)
#define TR_CLASSOFFSET_APPHMI_HALL              (1)
#define TR_CLASSOFFSET_APPHMI_GUI_DATABINDING   (2)   // former: TR_CLASSOFFSET_APPHMI_CGI_DATABINDING
#define TR_CLASSOFFSET_APPHMI_GUI_VISUALIZATION (3)   // former: TR_CLASSOFFSET_APPHMI_CGI_VISUALIZATION
#define TR_CLASSOFFSET_APPHMI_GUI_MESSAGING     (4)	// former: TR_CLASSOFFSET_APPHMI_CGI_MESSAGING
#define TR_CLASSOFFSET_APPHMI_GUI_DEBUG         (5)   // former: TR_CLASSOFFSET_APPHMI_CGI_DEBUG
#define TR_CLASSOFFSET_APPHMI_SM                (6)
#define TR_CLASSOFFSET_APPHMI__reserved7        (7)
#define TR_CLASSOFFSET_APPHMI__reserved8        (8)
#define TR_CLASSOFFSET_APPHMI_APPCTRL_PROXY     (9)
#define TR_CLASSOFFSET_APPHMI_GUI               (10)
#define TR_CLASSOFFSET_APPHMI_WIDGET            (11)
#define TR_CLASSOFFSET_APPHMI_DM                (12)
#define TR_CLASSOFFSET_APPHMI_CPL_MODEL         (13)
#define TR_CLASSOFFSET_APPHMI_CPL_VIEW          (14)
#define TR_CLASSOFFSET_APPHMI_CPL_CONTROLLER    (15)
#define TR_CLASSOFFSET_APPHMI_CPL_DATABINDING   (16)
#define TR_CLASSOFFSET_APPHMI_GUI_ASSETRESOURCE (17)   // former: TR_CLASSOFFSET_APPHMI_CGI_CANDERAASSET
//#define TR_CLASSOFFSET_APPHMI_ASF             (??)   // defined in json
#define TR_CLASSOFFSET_APPHMI_USER1             (TR_CLASSOFFSET_APPHMI_MAIN+32)  // first free ID that can be used by specific app implementation


// --- TRACE classes
//#define TR_CLASS_HMI_FW                         (TR_COMP_UI+ 0)  defined in Trace.h         // 0x2800 HMI_Framework or old monolithic HMI application
//#define TR_CLASS_HMI_FW_UTIL                    (TR_COMP_UI+ 1)  defined in Trace.h
#define TR_CLASS_HMI_FW_INPUT                   (TR_COMP_UI+ 2)
#define TR_CLASS_HMI_FW_COMMON_APPCTRL          (TR_COMP_UI+ 3)
#define TR_CLASS_HMI_FW_APPCTRL_STUB            (TR_COMP_UI+ 4)
#define TR_CLASS_HMI_FW_SBCLIENT                (TR_COMP_UI+ 5)
// use this as base for CGI traceclasses of individual components
#define TR_CLASS_HMI_CGI                        (TR_COMP_UI+ 6)
#define TR_CLASS_HMI_LISTPROVIDER               (TR_COMP_UI+ 7)   // FlexList ListDateProvider
#define TR_CLASS_HMI_FW_TIMER                   (TR_COMP_UI+ 8)
#define TR_CLASS_HMI_PERFORMANCE_MP             (TR_COMP_UI+ 9)
#define TR_CLASS_HMI_LANGUAGE_HANDLER           (TR_COMP_UI+ 10)  // deprecated
#define TR_CLASS_HMI_FW_FOCUS                   (TR_COMP_UI+ 10)  // 0x0A
// reserved for testimage daemon: #define TR_CLASS_HMI_TESTIMAGEDAEMON                       (TR_COMP_UI+ 11)  // 0x0B
#define TR_CLASS_HMI_FW_AUDIO_IF                (TR_COMP_UI+ 12)  // 0x0C
// reserved for trace daemon: #define TR_CLASS_HMI_BASE                       (TR_COMP_UI+ 13)  // 0x0D
#define TR_CLASS_HMI_COURIER_MSG_IN             (TR_COMP_UI+ 14)  // 0x0E   Msg Dispatcher
#define TR_CLASS_HMI_COURIER_MSG_OUT            (TR_COMP_UI+ 15)  // 0x0F   PostMsg()
#define TR_CLASS_HMI_DATABINDING                (TR_COMP_UI+ 16)  // 0x10   DataBindingPayload()
#define TR_CLASS_HMI_FW_DRAG_DROP               (TR_COMP_UI+ 17)
#define TR_CLASS_HMI_FW_IMAGE                   (TR_COMP_UI+ 18)
#define TR_CLASS_HMI_FW_COLOR                   (TR_COMP_UI+ 19)
#define TR_CLASS_HMI_FW_VIEW                    (TR_COMP_UI+ 20)  // 0x14
#define TR_CLASS_HMI_FW_WIDGET                  (TR_COMP_UI+ 21)  // 0x15
#define TR_CLASS_HMI_SM                         (TR_COMP_UI+ 22)  // 0x16
#define TR_CLASS_HMI_WIDGET_BASE                (TR_COMP_UI +64)  // reserved from 64..112 = 48 Widgets


#endif // FRAMEWORK_TRACE_H
