/* ***************************************************************************************
* FILE:          LegacyTouchDetector.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LegacyTouchDetector is part of HMI-Base Framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "sys_std_if.h"
#include "hmi_trace_if.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_INPUT
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/LegacyTouchDetector.cpp.trc.h"
#endif


#include "LegacyTouchDetector.h"
#include "IGestureListener.h"
#include "GestureHandler.h"

namespace hmibase {
namespace input {
namespace gesture {

LegacyTouchDetector::LegacyTouchDetector(IGestureListener* receiver, int gesturePriority) :
   GestureDetector(receiver, false, GestureEvent::GT_None),
   _gesturePriority(gesturePriority)
{
   //set gesture
   setGestureType(GestureEvent::GT_LegacyTouch);
   setGestureDetectorType(GestureEvent::GT_LegacyTouch);
}


LegacyTouchDetector::~LegacyTouchDetector()
{
   //empty
}


bool LegacyTouchDetector::registerGesture(IGestureListener* receiver, int gesturePriority)
{
   // GUI_ASSERT(receiver != 0);
   //init result flag
   bool result = false;

   if (GestureHandler::s_getInstance().getRegistrationEnabled())
   {
      //get detector
      GestureDetector* detector = new LegacyTouchDetector(receiver, gesturePriority);
      //   GUI_ASSERT(detector != 0);
      //register detector
      result = GestureHandler::s_getInstance().insertDetector(detector);
      if (!result)
      {
         //free detector if registration failed
         delete detector;
      }
   }

   return result;
}


void LegacyTouchDetector::cancel()
{
   IGestureListener* receiver = getReceiver();
   if (receiver != 0)
   {
      setEventType(GestureEvent::ET_ABORT);
      ETG_TRACE_USR4_THR(("LegacyTouchDetector [%25s]: gesture event, type %d, state %d", hmibase::trace::getAppName().c_str(),
                          ETG_CENUM(GestureEvent::GestureType, getGesture()._gestureType),
                          ETG_CENUM(GestureEvent::GestureState, getGesture()._gestureState)));
      getReceiver()->processGestureEvent(getGesture());
   }
}


bool LegacyTouchDetector::detect()
{
   bool detectingAndConsumed = false;
   IGestureListener* receiver = getReceiver();
   if (receiver != 0)
   {
      ETG_TRACE_USR4_THR(("LegacyTouchDetector [%25s]: gesture event, type %d, state %d", hmibase::trace::getAppName().c_str(),
                          ETG_CENUM(GestureEvent::GestureType, getGesture()._gestureType),
                          ETG_CENUM(GestureEvent::GestureState, getGesture()._gestureState)));
      detectingAndConsumed = receiver->processGestureEvent(getGesture());
   }

   // there is a high chance that somebody (e.g. ListWidget) registered for LegacyTouch and is not consuming
   // the event so the next registered listener has to be informed. Therefor we return not always false  here
   return detectingAndConsumed;
}


int LegacyTouchDetector::getPriority()
{
   return _gesturePriority;
}


}
}


}
