/* ***************************************************************************************
* FILE:          IMessagePostObject.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IMessagePostObject.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_IMessagePostObject_H)
#define _IMessagePostObject_H

#include "View/IMessageSystem.h"

namespace hmibase {

class IMessagePostObject
{
   public:
      virtual void postMsg(const Courier::RenderReqMsg&) = 0;
      virtual void postMsg(const SbAnimationStateChangedUpdMsg&) = 0;
      virtual void postMsg(const LayerStateChangedUpdMsg&) = 0;
      virtual void postMsg(const SbCurrentStatusUpdMsg&) = 0;
      virtual void postMsg(const SetClosePopupExternalTouchMsg&) = 0;
      virtual void postMsg(const SurfaceStateChangedUpdMsg&) = 0;
      virtual void postMsg(const PopupDisplayStatusUpdMsg&) = 0;
      virtual void postMsg(const ApplicationStateUpdMsg&) = 0;
      virtual void postMsg(const QueryTraceInfoReqMsg&) = 0;
      virtual void postMsg(const SubSurfaceSwitchCompleteUpdMsg&) = 0;
      virtual void postMsg(const SubSurfaceUpdMsg&) = 0;
      virtual void postMsg(const EncoderStatusChangedUpdMsg&) = 0;
      virtual void postMsg(const HKStatusChangedUpdMsg&) = 0;
      virtual void postMsg(const EnterKeyStatusChangedUpdMsg&) = 0;
      virtual void postMsg(const JoystickStatusChangedUpdMsg&) = 0;
      virtual void postMsg(const FocusControlReqMsg&) = 0;
      virtual void postMsg(const SimTouchReqMsg&) = 0;
      virtual void postMsg(const ::hmibase::gadget::SlaveSurfaceRepositionReqMsg&) = 0;
      virtual void postMsg(const ::hmibase::gadget::SlaveSurfaceRepositionResMsg&) = 0;
      virtual void postMsg(const ::hmibase::gadget::PositionInfoReqMsg&) = 0;
      virtual void postMsg(const ::hmibase::gadget::PositionInfoResMsg&) = 0;
      virtual void postMsg(const ::hmibase::gadget::ActivateImageProviderReqMsg&) = 0;
      virtual void postMsg(const ::hmibase::gadget::DrmGarbageCollectorReqMsg&) = 0;
      virtual void postMsg(const HMISubStateChangedUpdMsg&) = 0;

      static IMessagePostObject& s_getInstance();
};


}


#endif //
