/* ***************************************************************************************
* FILE:          MessagePostObjectImpl.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MessagePostObjectImpl.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_MessagePostObjectImpl_H)
#define _MessagePostObjectImpl_H

#include "MsgFwAbstraction/IMessagePostObject.h"

namespace hmibase {

class MessagePostObjectImpl : public IMessagePostObject
{
   public:
      virtual void postMsg(const Courier::RenderReqMsg&);
      virtual void postMsg(const SbAnimationStateChangedUpdMsg&);
      virtual void postMsg(const LayerStateChangedUpdMsg&);
      virtual void postMsg(const SbCurrentStatusUpdMsg&);
      virtual void postMsg(const SetClosePopupExternalTouchMsg&);
      virtual void postMsg(const SurfaceStateChangedUpdMsg&);
      virtual void postMsg(const PopupDisplayStatusUpdMsg&);
      virtual void postMsg(const ApplicationStateUpdMsg&);
      virtual void postMsg(const QueryTraceInfoReqMsg&);
      virtual void postMsg(const SubSurfaceSwitchCompleteUpdMsg&);
      virtual void postMsg(const SubSurfaceUpdMsg&);
      virtual void postMsg(const EncoderStatusChangedUpdMsg&);
      virtual void postMsg(const HKStatusChangedUpdMsg&);
      virtual void postMsg(const EnterKeyStatusChangedUpdMsg&);
      virtual void postMsg(const JoystickStatusChangedUpdMsg&);
      virtual void postMsg(const FocusControlReqMsg&);
      virtual void postMsg(const SimTouchReqMsg&);
      virtual void postMsg(const ::hmibase::gadget::SlaveSurfaceRepositionReqMsg&);
      virtual void postMsg(const ::hmibase::gadget::SlaveSurfaceRepositionResMsg&);
      virtual void postMsg(const ::hmibase::gadget::PositionInfoReqMsg&);
      virtual void postMsg(const ::hmibase::gadget::PositionInfoResMsg&);
      virtual void postMsg(const ::hmibase::gadget::ActivateImageProviderReqMsg&);
      virtual void postMsg(const ::hmibase::gadget::DrmGarbageCollectorReqMsg&);
      virtual void postMsg(const HMISubStateChangedUpdMsg&);
};


}

#endif //
