/* ***************************************************************************************
* FILE:          MessagePostObjectImpl.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MessagePostObjectImpl.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "MessagePostObjectImpl.h"

namespace hmibase {

POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, SbCurrentStatusUpdMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, SbAnimationStateChangedUpdMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, SurfaceStateChangedUpdMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, LayerStateChangedUpdMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, Courier::RenderReqMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, SetClosePopupExternalTouchMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, PopupDisplayStatusUpdMsg);

POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, ApplicationStateUpdMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, SubSurfaceSwitchCompleteUpdMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, FocusControlReqMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, SubSurfaceUpdMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, JoystickStatusChangedUpdMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, QueryTraceInfoReqMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, HKStatusChangedUpdMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, EnterKeyStatusChangedUpdMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, EncoderStatusChangedUpdMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, SimTouchReqMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, ::hmibase::gadget::SlaveSurfaceRepositionResMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, ::hmibase::gadget::SlaveSurfaceRepositionReqMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, ::hmibase::gadget::PositionInfoResMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, ::hmibase::gadget::PositionInfoReqMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, ::hmibase::gadget::ActivateImageProviderReqMsg);
POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, ::hmibase::gadget::DrmGarbageCollectorReqMsg);

POST_MESSAGE_IMPLEMENTATION(MessagePostObjectImpl, HMISubStateChangedUpdMsg);

IMessagePostObject& IMessagePostObject::s_getInstance()
{
   static MessagePostObjectImpl theInstance;
   return theInstance;
}


}
