/* ***************************************************************************************
* FILE:          StubHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  StubHandler.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIAPPCTRL_STUB_STUBHANDLER_H
#define HMIAPPCTRL_STUB_STUBHANDLER_H

#include "lint_deactivation.h"
#include "asf/core/Timer.h"
#include "AppTaskArray.h"
#include <vector>
#include <string>

#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlStub.h"
#include "StubHandlerMessaging.h"


namespace hmibase {
namespace services {
namespace hmiappctrl {

class StubHandler:
   public StubHandlerMessaging,
   public asf::core::TimerCallbackIF,
   public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlStub
{
   public:
      StubHandler();
      explicit StubHandler(unsigned int heartBeatTime);
      virtual ~StubHandler();

      // HMIAppCtrlServiceStub
      virtual void onUpdateClientStatusRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::UpdateClientStatusRequest >& request);
      virtual void onDisplayCmdRequest(const boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DisplayCmdRequest >&);
      virtual void onMultiDisplayCmdRequest(const boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultiDisplayCmdRequest >&);
      virtual void onDisplayStatusEvalRequest(const boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DisplayStatusEvalRequest >&);
      virtual void onKeyForwardingRequest(const boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyForwardingRequest >&);
      virtual void onEncoderForwardingRequest(const boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderForwardingRequest >&);
      virtual void onBeepForwardingRequest(const boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::BeepForwardingRequest >& data);
      virtual void onRequestExternalImageProviderActivationRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestExternalImageProviderActivationRequest >& request);
      virtual void onRequestExternalImageProviderTouchRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestExternalImageProviderTouchRequest >& request);
      virtual void onApplicationRenderedUpdateRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationRenderedUpdateRequest >& request);
      virtual void onApplicationSwitchCompleteRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationSwitchCompleteRequest >& request);
      virtual void onSubSurfaceSwitchCompleteRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SubSurfaceSwitchCompleteRequest >& request);
      virtual void onRequestSlaveSurfaceRepositioningRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestSlaveSurfaceRepositioningRequest >& request);
      virtual void onResponseSlaveSurfaceRepositioningRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseSlaveSurfaceRepositioningRequest >& request);
      virtual void onRequestDirectTextureConsumerPositionInfoRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestDirectTextureConsumerPositionInfoRequest >& request);
      virtual void onResponseDirectTextureConsumerPositionInfoRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseDirectTextureConsumerPositionInfoRequest >& request);
      virtual void onFollowUpActionRequest(const ::boost::shared_ptr<  bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionRequest >& request);
      virtual void onResponseFollowUpActionRequest(const ::boost::shared_ptr<  bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseFollowUpActionRequest >& request);
      virtual void onExternalImagesStatusGet(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusGet >& payload);
      virtual void onDrmBufferAllocationStatusRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DrmBufferAllocationStatusRequest >& request);

      // timer callback
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload>data);
      virtual unsigned int getPidOfMasterApp();
      // get pid
      unsigned int getPid(unsigned int appId);

   protected:
      void updateInitFlag(std::string sAppName);
      bool checkInitFlag();
      void sendApplicationInitialization();

   private:
      asf::core::Timer _timer;
      bool _appsInitialized;
      std::vector<std::string> _unknownAppNames;

      /** save currently allocated drm buffer per process */
      std::map<pid_t, uint64_t> _drmBufferStatistics;

   protected:
      AppTaskArray  _taskArray;
};


} // namespace
} // namespace
}


#endif // HMIAPPCTRL_STUB_STUBHANDLER_H
