/* ***************************************************************************************
* FILE:          ProxyHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ProxyHandler.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIAPPCTRL_PROXY_PROXYHANDLER_H
#define HMIAPPCTRL_PROXY_PROXYHANDLER_H

#ifdef WIN32  // todo:fr83hi

namespace hmibase {
namespace services {
namespace hmiappctrl {

class ProxyHandler
{
   public:
      ProxyHandler()
      {
         _myTraceID = 0;
         _isDirectApplicationActivationEnabled = true;
      }
      virtual ~ProxyHandler()
      {
      }

      void setName(const char* name)
      {
         _myName = name;
      }

      std::string getName()
      {
         return _myName;
      }

      void setTraceId(unsigned short id)
      {
         _myTraceID = id;
      }

      unsigned short getTraceId()
      {
         return _myTraceID;
      }

      void enableDirectApplicationActivation(bool state)
      {
         _isDirectApplicationActivationEnabled = state;
      }

      bool isDirectApplicationActivationEnabled()
      {
         return _isDirectApplicationActivationEnabled;
      }

   protected:
      std::string    _myName;
      unsigned short _myTraceID;

   private:
      bool _isDirectApplicationActivationEnabled;
      Candera::UInt32 userdata_1;
      Candera::UInt32 userdata_2;
      Courier::ViewId _viewid;
};


}  // namespace hmiappctrl
}  // namespace services
}  // namespace hmibase


#else // WIN32

#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlProxy.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsProxy.h"
#include "AppBase/IApplicationSettings.h"
#include "HMIAppCtrlAdapter.h"
#include "HMIBaseTraceCmdAdapter.h"
#include "hmibase/util/Macros.h"

namespace hmibase {
namespace services {
namespace hmiappctrl {

class ProxyHandler:
   public asf::core::ServiceAvailableIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::QueryClientCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EvDisplayStatusEvalCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetDisplayCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetMultiDisplayCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyInfoForwardingCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderInfoForwardingCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ActivateExternalImageProviderCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageProviderTouchCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SubSurfaceSwitchUpdateCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningAckCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoRequestCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoResponseCallbackIF
   , public bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQueryCallbackIF
   , public bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchCallbackIF
   , public bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByNameCallbackIF
   , public bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByIndexCallbackIF
   , public bosch::cm::ai::hmi::appctrl::trace::Commands::WidgetPropertyValueSetterCallbackIF
   , public bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextCallbackIF
   , public bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextIdCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionRequestCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionResponseCallbackIF
   , public bosch::cm::ai::hmi::appctrl::trace::Commands::SimEnterKeyCallbackIF
   , public bosch::cm::ai::hmi::appctrl::trace::Commands::SimFocusReqCallbackIF
   , public bosch::cm::ai::hmi::appctrl::trace::Commands::SimJoystickCallbackIF
   , public bosch::cm::ai::hmi::appctrl::trace::Commands::SimRotateEncoderCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusCallbackIF
   , public bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DrmGarbageCollectionRequestCallbackIF
{
   public:

      typedef enum
      {
         Application_Uninitialized,
         Application_Initialized
      } enApplicationState;

      ProxyHandler();
      virtual ~ProxyHandler();

      // ServiceAvailableIF
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // QueryClientCallbackIF
      virtual void onQueryClientError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::QueryClientError >& error);
      virtual void onQueryClientSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::QueryClientSignal >& signal);

      // SetDisplayCallbackIF
      virtual void onSetDisplayError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetDisplayError >& error);
      virtual void onSetDisplaySignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetDisplaySignal >& signal);

      // SetMultiDisplayCallbackIF
      virtual void onSetMultiDisplayError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetMultiDisplayError >& error);
      virtual void onSetMultiDisplaySignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetMultiDisplaySignal >& signal);

      // MultiDisplayCmdCallbackIF
      virtual void onMultiDisplayCmdError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultiDisplayCmdError >& error);
      virtual void onMultiDisplayCmdResponse(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultiDisplayCmdResponse >& response);

      // EvDisplayStatusEvalCallbackIF
      virtual void onEvDisplayStatusEvalError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EvDisplayStatusEvalError >& error);
      virtual void onEvDisplayStatusEvalSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EvDisplayStatusEvalSignal >& signal);

      // KeyInfoForwardingCallbackIF
      virtual void onKeyInfoForwardingError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyInfoForwardingError >& error);
      virtual void onKeyInfoForwardingSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyInfoForwardingSignal >& signal);

      // EncoderInfoForwardingCallbackIF
      virtual void onEncoderInfoForwardingError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& /*proxy*/, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderInfoForwardingError >& /*error*/);
      virtual void onEncoderInfoForwardingSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderInfoForwardingSignal >& signal);

      // ActivateExternalImageProviderCallbackIF
      virtual void onActivateExternalImageProviderError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ActivateExternalImageProviderError >& error);
      virtual void onActivateExternalImageProviderSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ActivateExternalImageProviderSignal >& signal);

      // SubSurfaceSwitchUpdateCallbackIF
      virtual void onSubSurfaceSwitchUpdateError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SubSurfaceSwitchUpdateError >& error);
      virtual void onSubSurfaceSwitchUpdateSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SubSurfaceSwitchUpdateSignal >& signal);

      //
      void onExternalImageProviderTouchError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageProviderTouchError >& error);
      void onExternalImageProviderTouchSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageProviderTouchSignal >& signal);

      // SlaveSurfaceRepositioningCallbackIF
      virtual void onSlaveSurfaceRepositioningError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningError >& error);
      virtual void onSlaveSurfaceRepositioningSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningSignal >& signal);

      // SlaveSurfaceRepositioningAckCallbackIF
      virtual void onSlaveSurfaceRepositioningAckError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningAckError >& error);
      virtual void onSlaveSurfaceRepositioningAckSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningAckSignal >& signal);

      // DirectTextureConsumerPositionInfoRequestCallbackIF
      virtual void onDirectTextureConsumerPositionInfoRequestError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoRequestError >& error);
      virtual void onDirectTextureConsumerPositionInfoRequestSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoRequestSignal >& signal);

      // DirectTextureConsumerPositionInfoResponseCallbackIF
      virtual void onDirectTextureConsumerPositionInfoResponseError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoResponseError >& error);
      virtual void onDirectTextureConsumerPositionInfoResponseSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoResponseSignal >& signal);

      // TraceQueryCallbackIF
      virtual void onTraceQueryError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQueryError >& error);
      virtual void onTraceQuerySignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQuerySignal >& signal);

      // SimTouchCallbackIF
      virtual void onSimTouchError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchError >& error);
      virtual void onSimTouchSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchSignal >& signal);

      // SimTouchByNameCallbackIF
      virtual void onSimTouchByNameError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByNameError >& error);
      virtual void onSimTouchByNameSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByNameSignal >& signal);

      // SimTouchByIndexCallbackIF
      virtual void onSimTouchByIndexError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByIndexError >& error);
      virtual void onSimTouchByIndexSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByIndexSignal >& signal);

      // WidgetPropertyValueSetterbackIF
      virtual void onWidgetPropertyValueSetterError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::WidgetPropertyValueSetterError >& error);
      virtual void onWidgetPropertyValueSetterSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::WidgetPropertyValueSetterSignal >& signal);

// SimTouchByTextIdCallbackIF
      virtual void onSimTouchByTextIdError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextIdError >& error);
      virtual void onSimTouchByTextIdSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextIdSignal >& sig);
// SimTouchByTextCallbackIF
      virtual void onSimTouchByTextError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextError >& error);
      virtual void onSimTouchByTextSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextSignal >& sig);

//FollowUpUserActionRequestCallbackIF
      virtual void onFollowUpActionRequestError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionRequestError >& error) ;
      virtual void onFollowUpActionRequestSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionRequestSignal >& signal) ;
// SimEnterKeyCallbackIF
      virtual void onSimEnterKeyError(const ::boost::shared_ptr<  bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr<  bosch::cm::ai::hmi::appctrl::trace::Commands::SimEnterKeyError >& error);
      virtual void onSimEnterKeySignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimEnterKeySignal >& signal);

//FollowUpUserActionResponseCallbackIF
      virtual void onFollowUpActionResponseError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionResponseError >& error) ;
      virtual void onFollowUpActionResponseSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionResponseSignal >& signal) ;
// SimFocusReqCallbackIF
      virtual void onSimFocusReqError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimFocusReqError >& error);
      virtual void onSimFocusReqSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimFocusReqSignal >& signal);

// SimJoystickCallbackIF
      virtual void onSimJoystickError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimJoystickError >& error);
      virtual void onSimJoystickSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimJoystickSignal >& signal);

// SimRotateEncoderCallbackIF
      virtual void onSimRotateEncoderError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimRotateEncoderError >& error);
      virtual void onSimRotateEncoderSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::SimRotateEncoderSignal >& signal);

      // ExternalImagesStatusCallbackIF
      virtual void onExternalImagesStatusError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusError >& error);
      virtual void onExternalImagesStatusUpdate(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusUpdate >& update);

      // DrmGarbageCollectionRequestCallbackIF
      virtual void onDrmGarbageCollectionRequestError(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DrmGarbageCollectionRequestError >& error);
      virtual void onDrmGarbageCollectionRequestSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DrmGarbageCollectionRequestSignal >& signal);

      // can be called from different thread
      void setAppState(::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::hmiAppState state);
      void evaluateKeyForwardingRequest(int HKCode, int HKState, int displayId, int userData);
      void evaluateEncoderForwardingRequest(int EncCode, int steps, int surfaceId, int userData);

      //
      template< typename T0 >
      act_t sendLocalMessageHMIBaseTraceCmd(const T0& t0)
      {
         if (_baseComponent != 0)
         {
            return _baseComponent->sendLocalMessage(_hmiBaseTraceCmdAdapter, t0);
         }
         HMI_APP_ASSERT_ALWAYS();
         return 0;
      }

      template< typename T0 >
      act_t sendLocalMessageHMIAppCtrl(const T0& t0)
      {
         if (_baseComponent != 0)
         {
            return _baseComponent->sendLocalMessage<T0>(_hmiAppCtrlAdapter, t0);
         }
         HMI_APP_ASSERT_ALWAYS();
         return 0;
      }

      virtual uint32 getSubSurface(uint32 displayid, uint32 displayregion);

      DEPRECATED1("This method provides no thread safe access to proxy object and will be removed soon, please use sendLocalMessageHMIAppCtrl instead", ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy > getHMIAppCtrlProxy())
      {
         return _hmiAppCtrlProxy;
      }

      void setName(const std::string& name)
      {
         _myName = name;
      }

      void setName(const char* name)
      {
         _myName = name;
      }

      const std::string& getName()
      {
         return _myName;
      }

      void setTraceId(unsigned short id)
      {
         _myTraceID = id;
      }

      unsigned short getTraceId()
      {
         return _myTraceID;
      }

      void setSurfaceIds(hmibase::SurfaceIds ids);
      void setSyncBlockId(unsigned int id)
      {
         _syncBlockId = id;
      }

      unsigned int getSyncBlockId() const
      {
         return _syncBlockId;
      }

      void enableDirectApplicationActivation(bool state)
      {
         _isDirectApplicationActivationEnabled = state;
      }

      bool isDirectApplicationActivationEnabled()
      {
         return _isDirectApplicationActivationEnabled;
      }

      void setBaseComponent(::asf::core::BaseComponent* baseComponent);

   private:
      act_t _hmiAppCtrlProxy_QueryClient_RegId;
      act_t _hmiAppCtrlProxy_SetDisplay_RegId;
      act_t _hmiAppCtrlProxy_SetMultiDisplay_RegId;
      act_t _hmiAppCtrlProxy_DisplayStatusEval_RegId;
      act_t _hmiAppCtrlProxy_TraceQuery_RegId;
      act_t _hmiAppCtrlProxy_KeyInfoForwarding_RegId;
      act_t _hmiAppCtrlProxy_EncoderInfoForwarding_RegId;
      act_t _hmiAppCtrlProxy_SubSurfaceSwitchUpd_RegId;
      act_t _hmiBaseTraceCommandProxy_RegId;
      act_t _hmiBaseSimTouchProxy_RegId;
      act_t _hmiBaseSimTouchByNameProxy_RegId;
      act_t _hmiBaseSimTouchByTextProxy_RegId;
      act_t _hmiBaseSimTouchByTextIdProxy_RegId;
      act_t _hmiBaseSimTouchByIndexProxy_RegId;
      act_t _hmiBaseSetWidgetPropertyProxy_RegId;
      act_t _hmiBaseSimEnterKeyProxy_RegId;
      act_t _hmiBaseSimFocusReqProxy_RegId;
      act_t _hmiBaseSimJoystickProxy_RegId;
      act_t _hmiBaseSimRotateEncoderProxy_RegId;
      act_t _hmiAppCtrlProxy_ExternalImageProviderTouch_RegId;
      act_t _hmiAppCtrlProxy_SlaveSurfaceRepositioning_RegId;
      act_t _hmiAppCtrlProxy_SlaveSurfaceRepositioningAck_RegId;
      act_t _hmiAppCtrlProxy_DirectTextureConsumerPositionInfo_RegId;
      act_t _hmiAppCtrlProxy_DirectTextureConsumerPositionInfoResponse_RegId;
      act_t _hmiAppCtrlProxy_DrmGarbageCollectionRequest_RegId;
      act_t _hmiAppCtrlProxy_FollowUpActionRequest_regId;
      act_t _hmiAppCtrlProxy_FollowUpActionResponse_regId;

      ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::hmiAppState _appState;

      bool _isDirectApplicationActivationEnabled;
      hmibase::SurfaceIds _surfaceIds;
      unsigned int _syncBlockId;

      ::asf::core::BaseComponent* _baseComponent;

   protected:
      ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy > _hmiAppCtrlProxy;
      ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy > _hmiBaseTraceCommandProxy;
      std::string _myName;
      unsigned short _myTraceID;

      hmibase::services::hmiappctrl::HMIAppCtrlAdapter _hmiAppCtrlAdapter;
      hmibase::services::hmiappctrl::HMIBaseTraceCmdAdapter _hmiBaseTraceCmdAdapter;
};


}  // namespace hmiappctrl
}  // namespace services
}  // namespace hmibase


#endif

#endif // HMIAPPCTRL_PROXY_PROXYHANDLER_H
