/* ***************************************************************************************
* FILE:          HMIBaseTraceCmdAdapter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HMIBaseTraceCmdAdapter.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "asf/core/BaseComponent.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsProxy.h"

namespace hmibase {
namespace services {
namespace hmiappctrl {


struct UpdateTraceQueryResultPayload
{
   ::bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQueryData _data;

   UpdateTraceQueryResultPayload(::bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQueryData data) :
      _data(data)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const UpdateTraceQueryResultPayload& payload)
   {
      os << payload._data.getPid();
      os << payload._data.getQueryId();

      for (size_t i = 0; i < payload._data.getQueryInput().size(); ++i)
      {
         os << payload._data.getQueryInput()[i];
      }
      return os;
   }
};


class ProxyHandler;

class HMIBaseTraceCmdAdapter :
   public ::asf::core::LocalMessageCallbackIF1< UpdateTraceQueryResultPayload >
{
   public:
      friend class ProxyHandler;

      HMIBaseTraceCmdAdapter();
      virtual ~HMIBaseTraceCmdAdapter();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < UpdateTraceQueryResultPayload > >& payload);

   private:

      void setProxy(::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy> proxy)
      {
         _proxy = proxy;
      }

      ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsProxy> _proxy;
};


}
}


}
