/* ***************************************************************************************
* FILE:          HMIAppCtrlAdapter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HMIAppCtrlAdapter.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "asf/core/BaseComponent.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlProxy.h"

namespace hmibase {
namespace services {
namespace hmiappctrl {


struct UpdateClientStatusPayload
{
   uint32_t _pid;
   std::string _name;
   ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::hmiAppState _state;

   UpdateClientStatusPayload(uint32_t pid, std::string& name, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::hmiAppState state) :
      _pid(pid),
      _name(name),
      _state(state)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const UpdateClientStatusPayload& payload)
   {
      os << payload._pid;
      os << payload._name;
      os << payload._state;
      return os;
   }
};


struct KeyForwardingPayload
{
   ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::keyInfo _keyInfo;

   KeyForwardingPayload(::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::keyInfo keyInfo) :
      _keyInfo(keyInfo)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const KeyForwardingPayload& payload)
   {
      os << payload._keyInfo.getKeyCode();
      os << payload._keyInfo.getKeyState();
      os << payload._keyInfo.getPidSender();
      os << payload._keyInfo.getPidReceiver();
      os << payload._keyInfo.getUserData();
      return os;
   }
};


struct EncoderForwardingPayload
{
   ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::encoderInfo _encoderInfo;

   EncoderForwardingPayload(::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::encoderInfo encoderInfo) :
      _encoderInfo(encoderInfo)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const EncoderForwardingPayload& payload)
   {
      os << payload._encoderInfo.getEncCode();
      os << payload._encoderInfo.getEncValue();
      os << payload._encoderInfo.getPidSender();
      os << payload._encoderInfo.getPidReceiver();
      os << payload._encoderInfo.getUserData();
      return os;
   }
};


struct BeepForwardingPayload
{
   int32_t _beepInfo;

   BeepForwardingPayload(int32_t beepInfo) :
      _beepInfo(beepInfo)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const BeepForwardingPayload& payload)
   {
      os << payload._beepInfo;
      return os;
   }
};


struct ApplicationMandatoryPayload
{
   std::string _name;
   bool _flag;

   ApplicationMandatoryPayload(std::string name, bool flag) :
      _name(name),
      _flag(flag)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const ApplicationMandatoryPayload& payload)
   {
      os << payload._name;
      os << payload._flag;
      return os;
   }
};


struct DisplayCmdPayload
{
   ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::displayData _displayData;

   DisplayCmdPayload(::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::displayData displayData) :
      _displayData(displayData)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const DisplayCmdPayload& payload)
   {
      os << payload._displayData.getPidReceiver();
      os << payload._displayData.getSenderName();
      os << payload._displayData.getReceiverName();
      os << payload._displayData.getDisplayRegion();
      os << payload._displayData.getRegionType();
      os << payload._displayData.getDisplayRegionStatus();
      return os;
   }
};


struct MultiDisplayCmdPayload
{
   ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultidisplayData _displayData;

   MultiDisplayCmdPayload(::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultidisplayData displayData) :
      _displayData(displayData)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const MultiDisplayCmdPayload& payload)
   {
      os << payload._displayData.getPidReceiver();
      os << payload._displayData.getDisplayid();
      os << payload._displayData.getSenderName();
      os << payload._displayData.getReceiverName();
      os << payload._displayData.getDisplayRegion();
      os << payload._displayData.getRegionType();
      os << payload._displayData.getDisplayRegionStatus();
      return os;
   }
};


struct DisplayStatusEvalPayload : public MultiDisplayCmdPayload
{
   DisplayStatusEvalPayload(::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultidisplayData displayData) :
      MultiDisplayCmdPayload(displayData)
   {
   }
};


struct RequestExternalImageProviderActivationPayload
{
   ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus _status;
   std::vector<int32_t> _ids;
   int32_t _consumerId;

   RequestExternalImageProviderActivationPayload(::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus status, const std::vector<int32_t>& ids, int32_t consumerId) :
      _status(status),
      _ids(ids),
      _consumerId(consumerId)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const RequestExternalImageProviderActivationPayload& payload)
   {
      os << payload._status;
      for (size_t i = 0; i < payload._ids.size(); ++i)
      {
         os << payload._ids[i];
      }
      os << payload._consumerId;
      return os;
   }
};


struct RequestExternalImageProviderTouchPayload
{
   uint32_t _pidSender;
   ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::touchInfo _touchInfo;
   int32_t _instanceId;

   RequestExternalImageProviderTouchPayload(uint32_t pidSender, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::touchInfo touchInfo, int32_t instanceId) :
      _pidSender(pidSender),
      _touchInfo(touchInfo),
      _instanceId(instanceId)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const RequestExternalImageProviderTouchPayload& payload)
   {
      os << payload._pidSender;
      os << payload._touchInfo.getTouchState();
      os << payload._touchInfo.getXPos();
      os << payload._touchInfo.getYPos();
      os << payload._touchInfo.getTimeStamp();
      os << payload._instanceId;
      return os;
   }
};


struct RequestExternalImageStatusGetPayload
{
   ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusCallbackIF* _callBack;
   RequestExternalImageStatusGetPayload(::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusCallbackIF* callBack) : _callBack(callBack)
   {
   }
   friend std::ostream& operator<<(std::ostream& os, const RequestExternalImageStatusGetPayload& payload)
   {
      os << payload._callBack;
      return os;
   }
};


struct RequestSlaveSurfaceRepositioningPayload
{
   uint32_t _pidSender;
   bool _activate;
   uint32_t _surfaceId;

   RequestSlaveSurfaceRepositioningPayload(uint32_t pidSender, bool activate, uint32_t surfaceId) :
      _pidSender(pidSender),
      _activate(activate),
      _surfaceId(surfaceId)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const RequestSlaveSurfaceRepositioningPayload& payload)
   {
      os << payload._pidSender;
      os << payload._activate;
      os << payload._surfaceId;
      return os;
   }
};


struct ResponseSlaveSurfaceRepositioningPayload
{
   uint32_t _pidSender;
   bool _activate;
   uint32_t _surfaceId;
   bool _status;

   ResponseSlaveSurfaceRepositioningPayload(uint32_t pidSender, bool activate, uint32_t surfaceId, bool status) :
      _pidSender(pidSender),
      _activate(activate),
      _surfaceId(surfaceId),
      _status(status)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const ResponseSlaveSurfaceRepositioningPayload& payload)
   {
      os << payload._pidSender;
      os << payload._activate;
      os << payload._surfaceId;
      os << payload._status;
      return os;
   }
};


struct RequestDirectTextureConsumerPositionInfoPayload
{
   uint32_t _pidSender;
   uint32_t _instanceId;

   RequestDirectTextureConsumerPositionInfoPayload(uint32_t pidSender, uint32_t instanceId) :
      _pidSender(pidSender),
      _instanceId(instanceId)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const RequestDirectTextureConsumerPositionInfoPayload& payload)
   {
      os << payload._pidSender;
      os << payload._instanceId;
      return os;
   }
};


struct ResponseDirectTextureConsumerPositionInfoPayload
{
   uint32_t _pidSender;
   uint32_t _instanceId;
   float _xPos;
   float _yPos;

   ResponseDirectTextureConsumerPositionInfoPayload(uint32_t pidSender, uint32_t instanceId, float xPos, float yPos) :
      _pidSender(pidSender),
      _instanceId(instanceId),
      _xPos(xPos),
      _yPos(yPos)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const ResponseDirectTextureConsumerPositionInfoPayload& payload)
   {
      os << payload._pidSender;
      os << payload._instanceId;
      os << payload._xPos;
      os << payload._yPos;
      return os;
   }
};


struct ApplicationRenderedUpdatePayload
{
   int32_t _surfaceId;

   ApplicationRenderedUpdatePayload(int32_t surfaceId) :
      _surfaceId(surfaceId)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const ApplicationRenderedUpdatePayload& payload)
   {
      os << payload._surfaceId;
      return os;
   }
};


struct ApplicationSwitchCompletePayload
{
   int32_t _surfaceId;
   int32_t _surfaceState;

   ApplicationSwitchCompletePayload(int32_t surfaceId, int32_t surfaceState) :
      _surfaceId(surfaceId),
      _surfaceState(surfaceState)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const ApplicationSwitchCompletePayload& payload)
   {
      os << payload._surfaceId;
      os << payload._surfaceState;
      return os;
   }
};


struct SubSurfaceSwitchCompletePayload
{
   int32_t _surfaceId;
   int32_t _surfaceState;

   SubSurfaceSwitchCompletePayload(int32_t surfaceId, int32_t surfaceState) :
      _surfaceId(surfaceId),
      _surfaceState(surfaceState)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const SubSurfaceSwitchCompletePayload& payload)
   {
      os << payload._surfaceId;
      os << payload._surfaceState;
      return os;
   }
};


struct FollowUpActionPayload
{
   ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction _actionType;
   uint32_t _userData;

   FollowUpActionPayload(::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction actionType, uint32_t userData) :
      _actionType(actionType),
      _userData(userData)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const FollowUpActionPayload& payload)
   {
      os << payload._actionType;
      os << payload._userData;
      return os;
   }
};


struct ResponseFollowUpActionPayload
{
   ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction _actionType;
   uint32_t _userData;

   ResponseFollowUpActionPayload(::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction actionType, uint32_t userData) :
      _actionType(actionType),
      _userData(userData)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const ResponseFollowUpActionPayload& payload)
   {
      os << payload._actionType;
      os << payload._userData;
      return os;
   }
};


struct DrmBufferAllocationStatusPayload
{
   int32_t _pid;
   ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::drmBufferAllocationStatus _status;
   uint32_t _bufferSize;

   DrmBufferAllocationStatusPayload(int32_t pid, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::drmBufferAllocationStatus status, uint32_t bufferSize) :
      _pid(pid),
      _status(status),
      _bufferSize(bufferSize)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const DrmBufferAllocationStatusPayload& payload)
   {
      os << payload._pid;
      os << payload._status;
      os << payload._bufferSize;
      return os;
   }
};


class ProxyHandler;

class HMIAppCtrlAdapter :
   public ::asf::core::LocalMessageCallbackIF1< UpdateClientStatusPayload >,
   public ::asf::core::LocalMessageCallbackIF1< KeyForwardingPayload >,
   public ::asf::core::LocalMessageCallbackIF1< EncoderForwardingPayload >,
   public ::asf::core::LocalMessageCallbackIF1< BeepForwardingPayload >,
   public ::asf::core::LocalMessageCallbackIF1< ApplicationMandatoryPayload >,
   public ::asf::core::LocalMessageCallbackIF1< DisplayCmdPayload >,
   public ::asf::core::LocalMessageCallbackIF1< MultiDisplayCmdPayload >,
   public ::asf::core::LocalMessageCallbackIF1< DisplayStatusEvalPayload >,
   public ::asf::core::LocalMessageCallbackIF1< RequestExternalImageProviderActivationPayload >,
   public ::asf::core::LocalMessageCallbackIF1< RequestExternalImageProviderTouchPayload >,
   public ::asf::core::LocalMessageCallbackIF1< RequestSlaveSurfaceRepositioningPayload >,
   public ::asf::core::LocalMessageCallbackIF1< RequestExternalImageStatusGetPayload >,
   public ::asf::core::LocalMessageCallbackIF1< ResponseSlaveSurfaceRepositioningPayload >,
   public ::asf::core::LocalMessageCallbackIF1< RequestDirectTextureConsumerPositionInfoPayload >,
   public ::asf::core::LocalMessageCallbackIF1< ResponseDirectTextureConsumerPositionInfoPayload >,
   public ::asf::core::LocalMessageCallbackIF1< ApplicationRenderedUpdatePayload >,
   public ::asf::core::LocalMessageCallbackIF1< ApplicationSwitchCompletePayload >,
   public ::asf::core::LocalMessageCallbackIF1< SubSurfaceSwitchCompletePayload >,
   public ::asf::core::LocalMessageCallbackIF1< FollowUpActionPayload >,
   public ::asf::core::LocalMessageCallbackIF1< ResponseFollowUpActionPayload >,
   public ::asf::core::LocalMessageCallbackIF1< DrmBufferAllocationStatusPayload >
{
   public:
      friend class ProxyHandler;

      HMIAppCtrlAdapter();
      virtual ~HMIAppCtrlAdapter();

      void setBaseComponent(::asf::core::BaseComponent* baseComponent);
      ::asf::core::BaseComponent* getBaseComponent();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < UpdateClientStatusPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < KeyForwardingPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < EncoderForwardingPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < BeepForwardingPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ApplicationMandatoryPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < DisplayCmdPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < MultiDisplayCmdPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < DisplayStatusEvalPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < RequestExternalImageProviderActivationPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < RequestExternalImageProviderTouchPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < RequestSlaveSurfaceRepositioningPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < RequestExternalImageStatusGetPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ResponseSlaveSurfaceRepositioningPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < RequestDirectTextureConsumerPositionInfoPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ResponseDirectTextureConsumerPositionInfoPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ApplicationRenderedUpdatePayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ApplicationSwitchCompletePayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < SubSurfaceSwitchCompletePayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < FollowUpActionPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ResponseFollowUpActionPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < DrmBufferAllocationStatusPayload > >& payload);

   private:

      void setProxy(::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy > proxy)
      {
         _proxy = proxy;
      }

      ::asf::core::BaseComponent* _baseComponent;
      ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy > _proxy;
};


}
}


}
