/* ***************************************************************************************
* FILE:          HMIAppCtrlAdapter.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HMIAppCtrlAdapter.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "HMIAppCtrlAdapter.h"

namespace hmibase {
namespace services {
namespace hmiappctrl {

HMIAppCtrlAdapter::HMIAppCtrlAdapter() : _baseComponent(0)
{
}


HMIAppCtrlAdapter::~HMIAppCtrlAdapter()
{
   _baseComponent = 0;
}


void HMIAppCtrlAdapter::setBaseComponent(::asf::core::BaseComponent* baseComponent)
{
   _baseComponent = baseComponent;
}


::asf::core::BaseComponent* HMIAppCtrlAdapter::getBaseComponent()
{
   return _baseComponent;
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < UpdateClientStatusPayload > >& payload)
{
   _proxy->sendUpdateClientStatusRequest(payload->get0()._pid, payload->get0()._name, payload->get0()._state);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < KeyForwardingPayload > >& payload)
{
   _proxy->sendKeyForwardingRequest(payload->get0()._keyInfo);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < EncoderForwardingPayload > >& payload)
{
   _proxy->sendEncoderForwardingRequest(payload->get0()._encoderInfo);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < BeepForwardingPayload > >& payload)
{
   _proxy->sendBeepForwardingRequest(payload->get0()._beepInfo);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ApplicationMandatoryPayload > >& payload)
{
   _proxy->sendSetApplicationMandatoryRequest(payload->get0()._name, payload->get0()._flag);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < DisplayCmdPayload > >& payload)
{
   _proxy->sendDisplayCmdRequest(payload->get0()._displayData);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < MultiDisplayCmdPayload > >& payload)
{
   _proxy->sendMultiDisplayCmdRequest(payload->get0()._displayData);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < DisplayStatusEvalPayload > >& payload)
{
   _proxy->sendDisplayStatusEvalRequest(payload->get0()._displayData);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < RequestExternalImageProviderActivationPayload > >& payload)
{
   _proxy->sendRequestExternalImageProviderActivationRequest(payload->get0()._status, payload->get0()._ids, payload->get0()._consumerId);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < RequestExternalImageProviderTouchPayload > >& payload)
{
   _proxy->sendRequestExternalImageProviderTouchRequest(payload->get0()._pidSender, payload->get0()._touchInfo, payload->get0()._instanceId);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < RequestSlaveSurfaceRepositioningPayload > >& payload)
{
   _proxy->sendRequestSlaveSurfaceRepositioningRequest(payload->get0()._pidSender, payload->get0()._activate, payload->get0()._surfaceId);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < RequestExternalImageStatusGetPayload > >& payload)
{
   _proxy->sendExternalImagesStatusGet(*(payload->get0()._callBack));
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ResponseSlaveSurfaceRepositioningPayload > >& payload)
{
   _proxy->sendResponseSlaveSurfaceRepositioningRequest(payload->get0()._pidSender, payload->get0()._activate, payload->get0()._surfaceId, payload->get0()._status);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < RequestDirectTextureConsumerPositionInfoPayload > >& payload)
{
   _proxy->sendRequestDirectTextureConsumerPositionInfoRequest(payload->get0()._pidSender, payload->get0()._instanceId);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ResponseDirectTextureConsumerPositionInfoPayload > >& payload)
{
   _proxy->sendResponseDirectTextureConsumerPositionInfoRequest(payload->get0()._pidSender, payload->get0()._instanceId, payload->get0()._xPos, payload->get0()._yPos);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ApplicationRenderedUpdatePayload > >& payload)
{
   _proxy->sendApplicationRenderedUpdateRequest(payload->get0()._surfaceId);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ApplicationSwitchCompletePayload > >& payload)
{
   _proxy->sendApplicationSwitchCompleteRequest(payload->get0()._surfaceId, payload->get0()._surfaceState);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < SubSurfaceSwitchCompletePayload > >& payload)
{
   _proxy->sendSubSurfaceSwitchCompleteRequest(payload->get0()._surfaceId, payload->get0()._surfaceState);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < FollowUpActionPayload > >& payload)
{
   _proxy->sendFollowUpActionRequest(payload->get0()._actionType, payload->get0()._userData);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ResponseFollowUpActionPayload > >& payload)
{
   _proxy->sendResponseFollowUpActionRequest(payload->get0()._actionType, payload->get0()._userData);
}


void HMIAppCtrlAdapter::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < DrmBufferAllocationStatusPayload > >& payload)
{
   _proxy->sendDrmBufferAllocationStatusRequest(payload->get0()._pid, payload->get0()._status, payload->get0()._bufferSize);
}


}
}


}
