/* ***************************************************************************************
* FILE:          FSerialization.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FSerialization.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_SERIALIZATION_H__
#define __FOCUS_SERIALIZATION_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "FCommon.h"

namespace Focus {
class FAppConfig;
class FAppState;
class FConfigInfo;
class FStateInfo;

class FSerializer
{
   public:
      virtual ~FSerializer() {}

      virtual bool serialize(FConfigInfo& configInfo, FStateInfo& stateInfo) = 0;
      virtual bool deserialize(FConfigInfo& configInfo, FStateInfo& stateInfo) = 0;
};


}
#endif
