/* ***************************************************************************************
* FILE:          FManagerConfig.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FManagerConfig.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FManagerConfig.h"
#include "FManager.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FManagerConfig.cpp.trc.h"
#endif

namespace Focus {

FManagerConfiguration::FManagerConfiguration() :
   _currentAppId(0),
   _rootGroupControllerSetId(Constants::InvalidControllerSetId),
   _activityTimer(NULL),
   _watchdogTimer(NULL),
   _avgManager(NULL),
   _animationManager(NULL),
   _consistencyChecker(NULL),
   _visibilityManager(NULL),
   _inputMsgQueue(NULL),
   _inputMsgChecker(NULL),
   _ipcManager(NULL),
   _outputMsgHandler(NULL),
   _sessionManager(NULL),
   _taskFactory(NULL),
   _taskManager(NULL)
{
}


FManagerConfiguration::~FManagerConfiguration()
{
   _activityTimer = NULL;
   _watchdogTimer = NULL;
   _avgManager = NULL;
   _animationManager = NULL;
   _consistencyChecker = NULL;
   _visibilityManager = NULL;
   _inputMsgQueue = NULL;
   _inputMsgChecker = NULL;
   _ipcManager = NULL;
   _outputMsgHandler = NULL;
   _sessionManager = NULL;
   _taskFactory = NULL;
   _taskManager = NULL;
}


}
