/* ***************************************************************************************
* FILE:          FConfigInfo.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FConfigInfo.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FConfigInfo.h"
#include "FData.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FConfigInfo.cpp.trc.h"
#endif

namespace Focus {

FViewConfig::FViewConfig(const FViewId& id, FAppConfig& app) : Base(id), App(app)
{
   //create the root group for every view
   FWidgetConfig* rootGroupConfig = getOrCreateChild(Constants::InvalidId);
   if (rootGroupConfig != NULL)
   {
      FWidgetData widgetData;
      widgetData.SequenceNr = 0;
      rootGroupConfig->Data.set(widgetData);

      rootGroupConfig->Data.set(FGroupData());
   }
}


FViewConfig* FAppConfig::createChild(const FViewId& id)
{
   return FOCUS_NEW(FViewConfig)(id, *this);
}


FWidgetConfig* FViewConfig::createChild(const FId& id)
{
   return FOCUS_NEW(FWidgetConfig)(id, *this);
}


}
