/* ***************************************************************************************
* FILE:          FDefaultTaskManager.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultTaskManager.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FDefaultTaskManager.h"
#include "Focus/FData.h"
#include "Focus/FManager.h"
#include "Focus/FSession.h"
#include "Focus/FController.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FDefaultTaskManager.cpp.trc.h"
#endif

namespace Focus {
FDefaultTaskManager::FDefaultTaskManager(FManager& manager)
   : _manager(manager),
     _executingTask(NULL),
     _taskExecutionCount(0)
{
}


FDefaultTaskManager::~FDefaultTaskManager()
{
   _executingTask = NULL;

   while (!_taskQueue.empty())
   {
      FTask* task = _taskQueue.front();
      if (task != NULL)
      {
         FOCUS_DELETE(task);
         task = NULL;
      }
      _taskQueue.pop();
   }     //lint !e438 intended
}


void FDefaultTaskManager::clearTasks()
{
   while (!_taskQueue.empty())
   {
      FTask* task = _taskQueue.front();
      if (task != NULL)
      {
         FOCUS_DELETE(task);
         task = NULL;
      }
      _taskQueue.pop();
   }     //lint !e438 intended
}


void FDefaultTaskManager::addTask(FTask* task)
{
   if (task != NULL)
   {
      _taskQueue.push(task);
   }
}


FTask::Result FDefaultTaskManager::executeTasks()
{
   FTask::Result result = FTask::Completed;
   while ((result == FTask::Completed) && !_taskQueue.empty())
   {
      if ((_manager.getSessionManager() != NULL)
            && (_manager.getSessionManager()->isSessionSuspended()))
      {
         result = FTask::Suspended;
      }
      else
      {
         FTask* task = _taskQueue.front();
         if (task == NULL)
         {
            _taskQueue.pop();
         }
         else
         {
            _executingTask = task;
            result = task->execute();
            ++_taskExecutionCount;
            _executingTask = NULL;

            switch (result)
            {
               case FTask::Completed:
               {
                  FOCUS_DELETE(task);
                  task = NULL;
                  _taskQueue.pop();
                  break;
               }

               case FTask::Error:
               {
                  ETG_TRACE_ERR_THR(("FDefaultTaskManager::executeTasks task failed!"));
                  break;
               }

               default:
               {
                  ETG_TRACE_USR1_THR(("FDefaultTaskManager::executeTasks task not completed!"));
                  break;
               }
            }
         }
      }  //lint !e438 intended
   }
   return result;
}


bool FDefaultTaskManager::configureTasks(FSession& session)
{
   if (_manager.getTaskFactory() != NULL)
   {
      return _manager.getTaskFactory()->configureTasks(*this, session);
   }
   return false;
}


}
