/* ***************************************************************************************
* FILE:          FDefaultReqController.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultReqController.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FDefaultReqController.h"
#include "FDefaultAvgBuilder.h"
#include "Focus/FCommon.h"
#include "Focus/FManager.h"


#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FDefaultReqController.cpp.trc.h"
#endif


namespace Focus {

bool FDefaultReqController::onMessage(FSession& session, FGroup& group, const FMessage& msg)
{
   (void)group;

   bool consumed = false;
   if (msg.GetId() == FocusControlReqMsg::ID)
   {
      const FocusControlReqMsg* reqMsg = Courier::message_cast<const FocusControlReqMsg*>(&msg);
      if (reqMsg != NULL)
      {
         if ((_manager.getActivityTimer() != NULL) && (reqMsg->GetTimerAction() != hmibase::enFocusTimerNoAction))
         {
            _manager.getActivityTimer()->stop();
         }

         switch (reqMsg->GetAction())
         {
            case hmibase::enFocusShow:
            {
               _manager.setFocus(session, reqMsg->GetView(), reqMsg->GetWidget().GetCString());
               if (!_manager.isFocusVisible())
               {
                  _manager.generateNewSequenceId();
                  _manager.setFocusVisible(true);
               }
            }
            break;

            case hmibase::enFocusSet:
            {
               _manager.setFocus(session, reqMsg->GetView(), reqMsg->GetWidget().GetCString());
               session.Data.set(FSessionFocusVisibilityUpdateConfig(false));
            }
            break;

            case hmibase::enFocusHide:
            {
               if (reqMsg->GetView() != Constants::InvalidViewId)
               {
                  if (!_manager.getCurrentAppState().PointsToNull())
                  {
                     FViewState* viewState = _manager.getCurrentAppState()->getChild(reqMsg->GetView());         //lint !e1793
                     if (viewState != NULL)
                     {
                        viewState->setData(FViewFocusVisible(false));
                     }
                  }
               }
               else
               {
                  _manager.setFocusVisible(false);
               }

               //prevent avg builder to overwrite the visibility info of the views at the end of a session
               session.Data.set(FSessionFocusVisibilityUpdateConfig(false));
            }
            break;

            default:
               break;
         }

         if ((_manager.getActivityTimer() != NULL) && (reqMsg->GetTimerAction() == hmibase::enFocusTimerRestart))
         {
            _manager.getActivityTimer()->restart();
         }
         consumed = true;
      }
   }
   return consumed;
}


}
