/* ***************************************************************************************
* FILE:          FDefaultOtherAppsExchange.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultOtherAppsExchange.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_OTHER_APPS_EXCHANGE_H__
#define __FOCUS_DEFAULT_OTHER_APPS_EXCHANGE_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FTask.h"

namespace Focus {
//////////////////////////////////////////////////////////////////////////////////////////////
class FSession;
class FManager;

//////////////////////////////////////////////////////////////////////////////////////////////
class FDefaultIpcCrtAppInfoPublisher : public FSessionUpdater
{
      typedef FSessionUpdater Base;

   public:
      FDefaultIpcCrtAppInfoPublisher(FManager& manager) : Base(manager) {}
      virtual ~FDefaultIpcCrtAppInfoPublisher() {};

      virtual FTask::Result update(FSession& session);

   private:
      FDefaultIpcCrtAppInfoPublisher(const FDefaultIpcCrtAppInfoPublisher&);
      FDefaultIpcCrtAppInfoPublisher& operator=(const FDefaultIpcCrtAppInfoPublisher&);
};


//////////////////////////////////////////////////////////////////////////////////////////////
class FDefaultIpcOtherAppsInfoCollector : public FSessionUpdater
{
      typedef FSessionUpdater Base;

   public:
      FDefaultIpcOtherAppsInfoCollector(FManager& manager) : Base(manager), _error(false), _requestSent(false) {}
      virtual ~FDefaultIpcOtherAppsInfoCollector() {};

      virtual FTask::Result update(FSession& session);

   protected:
      bool _error;
      bool _requestSent;

   private:
      FDefaultIpcOtherAppsInfoCollector(const FDefaultIpcOtherAppsInfoCollector&);
      FDefaultIpcOtherAppsInfoCollector& operator=(const FDefaultIpcOtherAppsInfoCollector&);
};


//////////////////////////////////////////////////////////////////////////////////////////////
class FDefaultIpcOtherAppsStatePublisher : public FSessionUpdater
{
      typedef FSessionUpdater Base;

   public:
      FDefaultIpcOtherAppsStatePublisher(FManager& manager) : Base(manager) {}
      virtual ~FDefaultIpcOtherAppsStatePublisher() {};

      virtual FTask::Result update(FSession& session);

   private:
      FDefaultIpcOtherAppsStatePublisher(const FDefaultIpcOtherAppsStatePublisher&);
      FDefaultIpcOtherAppsStatePublisher& operator=(const FDefaultIpcOtherAppsStatePublisher&);
};


//////////////////////////////////////////////////////////////////////////////////////////////
class FDefaultSlaveAppUpdater : public FTask
{
      typedef FTask Base;

   public:
      FDefaultSlaveAppUpdater(FManager& manager) : Base(manager) {}
      virtual ~FDefaultSlaveAppUpdater() {};

      virtual FTask::Result execute();

   private:
      FDefaultSlaveAppUpdater(const FDefaultSlaveAppUpdater&);
      FDefaultSlaveAppUpdater& operator=(const FDefaultSlaveAppUpdater&);
};


}

#endif
