/* ***************************************************************************************
* FILE:          FDefaultManagerConfig.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultManagerConfig.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_MANAGER_CONFIG_H__
#define __FOCUS_DEFAULT_MANAGER_CONFIG_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FCourierAdapter.h"
#include "Focus/FManagerConfig.h"

namespace Focus {
class FManager;
class FCourierTimer;
class FDefaultManagerConfigurator : public FManagerConfigurator
{
      typedef FManagerConfigurator Base;

   public:
      static const FControllerSetId DefaultRootGroupControllerSetId = 0;

      FDefaultManagerConfigurator(FManager& manager, AppViewHandler* viewHandler = NULL);
      virtual ~FDefaultManagerConfigurator();

      virtual bool initialize();
      virtual bool finalize();

   protected:
      FCourierTimer* getActivityTimer() const;
      FCourierTimer* getWatchdogTimer() const;
      AppViewHandler* getViewHandler() const;

      virtual bool initializeTimers();
      virtual bool finalizeTimers();

      virtual bool initializeControllers();
      virtual bool finalizeControllers();
      void clearControllerSet(FControllerSetId setId, bool performDelete);

      virtual bool initializeAvgManager();
      virtual bool finalizeAvgManager();

      virtual bool initializeAnimationManager();
      virtual bool finalizeAnimationManager();

      virtual bool initializeConsistencyChecker();
      virtual bool finalizeConsistencyChecker();

      virtual bool initializeVisibilityManager();
      virtual bool finalizeVisibilityManager();

      virtual bool initializeInputMsgQueue();
      virtual bool finalizeInputMsgQueue();

      virtual bool initializeInputMsgChecker();
      virtual bool finalizeInputMsgChecker();

      virtual bool initializeIpcManager();
      virtual bool finalizeIpcManager();

      virtual bool initializeOutputMsgHandler();
      virtual bool finalizeOutputMsgHandler();

      virtual bool initializeSessionManager();
      virtual bool finalizeSessionManager();

      virtual bool initializeTaskFactory();
      virtual bool finalizeTaskFactory();

      virtual bool initializeTaskManager();
      virtual bool finalizeTaskManager();

      FManager& _manager;

      FCourierTimer* _activityTimer;
      FCourierTimer* _watchdogTimer;
      AppViewHandler* _viewHandler;
};


}

#endif
