/* ***************************************************************************************
* FILE:          FDefaultDisplayCoordinateController.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultDisplayCoordinateController.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_DISPLAY_COORDINATE_CONTROLLER_H__
#define __FOCUS_DEFAULT_DISPLAY_COORDINATE_CONTROLLER_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FController.h"

namespace Focus {
/**************************************************************************/
/* FORWARD DECLARATIONS                                                   */
/**************************************************************************/
class FManager;
class FWidgetConfig;


/**************************************************************************/
/* Use this controller for the root focus group (or any other widget) in a scene to get information about the cameras.
* See structure FCameraData.
*/
/**************************************************************************/
class FDefaultDisplayCoordinateController : public FController
{
   public:
      virtual bool configureWidget(FSession&, FWidgetConfig&, FFrameworkWidget&);
};


}
#endif
