/* ***************************************************************************************
* FILE:          FDefaultAvgBuilder.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultAvgBuilder.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_AVG_BUILDER_H__
#define __FOCUS_DEFAULT_AVG_BUILDER_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FTask.h"
#include "Focus/FConfigInfo.h"
#include "Focus/FStateInfo.h"

namespace Focus {
//////////////////////////////////////////////////////////////////////////////////////////////
class FSession;
class FManager;
class FWidgetConfig;
class FViewConfig;
class FAppConfig;
class FGroupState;
class FViewState;
class FAppState;
class Focusable;
class FWidget;
class FGroup;
class FActiveViewGroup;
class FWidgetData;
class FGroupData;

//////////////////////////////////////////////////////////////////////////////////////////////
// Specifies if the focus visibility should be updated in the view states at the end of the session.
// Default is true but different controllers may set it to false.
//////////////////////////////////////////////////////////////////////////////////////////////
struct FSessionFocusVisibilityUpdateConfig
{
   FSessionFocusVisibilityUpdateConfig(bool shouldUpdate = false) : ShouldUpdate(shouldUpdate) {}

   bool ShouldUpdate;
};


class FDefaultAvgSessionUpdater : public FSessionUpdater
{
      typedef FSessionUpdater Base;

   public:
      FDefaultAvgSessionUpdater(FManager& manager) : Base(manager) {}
      virtual ~FDefaultAvgSessionUpdater() {}

   protected:
      bool updateAllViewsEx(FSession& session, FAppConfigSharedPtr appConfig, FAppStateSharedPtr appState);
      bool updateAllWidgetsEx(FSession& session, const FViewConfig& viewConfig, FViewState& viewState);

   protected:
      virtual bool updateApp(FSession& session, FAppConfigSharedPtr appConfig);
      virtual bool updateAppEx(FSession&, FAppConfigSharedPtr, FAppStateSharedPtr)
      {
         return true;
      }
      virtual bool updateViewEx(FSession&, FViewConfig&, FViewState&)
      {
         return true;
      }
      virtual bool updateWidgetEx(FSession&, FWidgetConfig&, FViewState&)
      {
         return true;
      }

   private:
      FDefaultAvgSessionUpdater(const FDefaultAvgSessionUpdater&);
      FDefaultAvgSessionUpdater& operator=(const FDefaultAvgSessionUpdater&);
};


//////////////////////////////////////////////////////////////////////////////////////////////
class FDefaultAvgBuilder : public FDefaultAvgSessionUpdater
{
      typedef FDefaultAvgSessionUpdater Base;

   public:
      FDefaultAvgBuilder(FManager& manager) : Base(manager), _anchorContentMergeInProgress(false) {}
      virtual ~FDefaultAvgBuilder() {}

      virtual FTask::Result update(FSession& session);

   protected:
      virtual bool updateAppEx(FSession& session, FAppConfigSharedPtr appConfig, FAppStateSharedPtr appState);
      virtual bool updateViewEx(FSession& session, FViewConfig& viewConfig, FViewState& viewState);
      virtual bool updateWidgetEx(FSession& session, FWidgetConfig& widgetConfig, FViewState& viewState);
      virtual bool updateEffectiveOrderRank(FSession& session);

      virtual void handleAsWidget(FSession& session, FWidgetConfig& widgetConfig, const FWidgetData* widgetData, const FGroupData* groupData);
      virtual void handleAsGroup(FSession& session, FViewState& viewState, FWidgetConfig& widgetConfig, const FWidgetData* widgetData, const FGroupData* groupData);

      virtual FGroup* findParentGroup(FSession& session, const FWidgetConfig& widgetConfig);
      virtual bool connectToParentGroup(FSession& session);

      bool _anchorContentMergeInProgress;

   private:
      FDefaultAvgBuilder(const FDefaultAvgBuilder&);
      FDefaultAvgBuilder& operator=(const FDefaultAvgBuilder&);
};


//////////////////////////////////////////////////////////////////////////////////////////////
class FAvg2FocusInfoUpdater : public FDefaultAvgSessionUpdater
{
      typedef FDefaultAvgSessionUpdater Base;

   public:
      FAvg2FocusInfoUpdater(FManager& manager) : Base(manager) {}
      virtual ~FAvg2FocusInfoUpdater() {}

      virtual FTask::Result update(FSession& session);

   protected:
      virtual bool updateAppEx(FSession& session, FAppConfigSharedPtr appConfig, FAppStateSharedPtr appState);
      virtual bool updateViewEx(FSession& session, FViewConfig& viewConfig, FViewState& viewState);

   private:
      FAvg2FocusInfoUpdater(const FAvg2FocusInfoUpdater&);
      FAvg2FocusInfoUpdater& operator=(const FAvg2FocusInfoUpdater&);
};


}

#endif
