/* ***************************************************************************************
* FILE:          FDefaultAnimationManager.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultAnimationManager.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_ANIMATION_MANAGER_H__
#define __FOCUS_DEFAULT_ANIMATION_MANAGER_H__

#include "Candera/EngineBase/Animation/AnimationPlayerListener.h"

//lint -esym(1704, Focus::FDefaultAnimationManager::FDefaultAnimationManager) private constructor
//lint -esym(1712, FDefaultAnimationManager)          default constructor not defined
/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FData.h"
#include "Focus/FManagerConfig.h"

namespace hmibase {
namespace view {
class AnimatedPropertyWrapper;
class AnimationWrapper;
}


}
class FocusGroupWidget2D;

namespace Focus {

//////////////////////////////////////////////////////////////////////////////////////////////
//indicates that a marker node is set on the focus group
struct FMarkerNodeData : public FMarkerData
{
   FMarkerNodeData(bool value = true) : FMarkerData(value) {}
};


//////////////////////////////////////////////////////////////////////////////////////////////
class FDefaultAnimationManager : public FAnimationManager, public FListener, public Candera::Animation::AnimationPlayerListener
{
   public:
      FDefaultAnimationManager(FManager& manager, AppViewHandler& viewhandler);
      virtual ~FDefaultAnimationManager();

      //overrides from FAnimationManager
      virtual bool isAnimationRunning(FFrameworkWidget* widget);

      //overrides from FListener
      virtual void onInternalSetFocus(FSession& session, Focusable* newFocus);

      //overrides from Candera::Animation::AnimationPlayerListener
      virtual void OnStartAnimation(Candera::Animation::AnimationPlayerBase* animationPlayer);
      virtual void OnStopAnimation(Candera::Animation::AnimationPlayerBase* animationPlayer);
      virtual void OnFinishAnimation(Candera::Animation::AnimationPlayerBase* animationPlayer);
      virtual void OnPastEnd(Candera::Animation::AnimationPlayerBase* animationPlayer, Candera::Int32 completedIterationsCount);

   protected:
      void initAnimation();
      //FocusGroupWidget2D* getFocusGroupWidget(const FViewWidgetId& widgetId) const;
      FViewWidgetId getMarkerGroupId(const FWidget& widget) const;

      //register focus listener to focus manager
      void registerListener();
      //unregister focus listener to focus manager
      void unregisterListener() const;

      FManager& _manager;
      AppViewHandler& _viewHandler;

      //focus group widget id which had the last focus marker node activated
      FViewWidgetId _markerGroupId;
      //animated property for the focus marker node
      ::hmibase::view::AnimatedPropertyWrapper* _markerAnimatedProperty;
      //animation for the focus marker node
      ::hmibase::view::AnimationWrapper* _markerAnimation;

   private:
      FDefaultAnimationManager(const FDefaultAnimationManager&);
      FDefaultAnimationManager& operator=(const FDefaultAnimationManager&);
};


}
#endif
