/* ***************************************************************************************
* FILE:          Timer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Timer.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(Util_Timer_h)
#define Util_Timer_h

#include "hmibase/util/TimerThreaded.h"

namespace Courier {
class Message;
class MessageReferrer;
}


namespace hmibase {
class Message;
}


class TimerExpiredMsg;

namespace Util {


class Timer : public ::hmibase::util::TimerThreaded, public ::hmibase::util::TimerThreaded::ITimerFunction
{
   public:
      Timer();
      Timer(uint32_t timeout);
      virtual ~Timer();

      typedef void (*TimeOutCallBack)(Courier::Message* Msg) ;
      bool setTimeoutWithRepeat(uint32_t timeout, uint32_t repeatTime, Courier::Message* pNotifyMsg = NULL, TimeOutCallBack callback = NULL);
      bool setTimeout(uint32_t timIndex, uint32_t timeout, Courier::Message* pNotifyMsg = NULL);
      void resetTimeouts();
      bool ownMessage(const TimerExpiredMsg& oMsg) const;

      virtual void timerExpired(::hmibase::util::TimerThreaded::TimerId timerId, uint32_t index) override;
   private:
      TimeOutCallBack            _callback;
      Courier::MessageReferrer*  _msgRefs[TIMER_MAX_TIME_OUTS + 1];

      HMIBASE_UNCOPYABLE(Timer);
};


} // namespace Util


#endif  // _Timer_h
