/* ***************************************************************************************
* FILE:          HmiMacros.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HmiMacros.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __HMIMACROS_H
#define __HMIMACROS_H

#include "hmibase/util/Macros.h"

#ifdef FEATSTD_THREADSAFETY_ENABLED
#define SECURE_FEATSTD_STRING_ACCESS_BEGIN(c) { \
                                          FeatStd::Internal::CriticalSectionLocker lock(c.GetCriticalSection());
#define SECURE_FEATSTD_STRING_ACCESS_END() }
#else
#define SECURE_FEATSTD_STRING_ACCESS_BEGIN(c)
#define SECURE_FEATSTD_STRING_ACCESS_END()
#endif

#endif // __HMIMACROS_H
