/* ***************************************************************************************
* FILE:          Source.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Source.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef Source_h
#define Source_h

#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "AppHmi_MasterBase/AudioInterface/Resource.h"
#include <map>
#include <string>

namespace hmibase {
namespace apphmi_master {
namespace audio {

struct SrcDetails
{
   SrcDetails(): responseState(STATE_UNKNOWN), sourceType(SOURCE_MAIN) {}
   SrcDetails(int state, int type): responseState(state), sourceType(type) {}
   int responseState;
   int sourceType;
};


class SrcMap
{
   private:
      static SrcMap* m_pSrcMap;
      ::std::map<std::string, int> SrcMapID;
      ::std::map<int, SrcDetails> SrcMapState;

   public:
      static SrcMap* getSrcMapInstance();
      ~SrcMap()
      {
         SrcMapID.clear();
      }
      inline int getSourceId(std::string srcName)
      {
         ::std::map<std::string, int>::iterator itr;
         itr = SrcMapID.find(srcName);
         if (itr != SrcMapID.end())
         {
            return itr->second;
         }
         else
         {
            return SRC_INVALID;
         }
      }

      inline int getResponseState(int srcIdx)
      {
         ::std::map<int, SrcDetails>::iterator itr;
         itr = SrcMapState.find(srcIdx);
         if (itr != SrcMapState.end())
         {
            return itr->second.responseState;
         }
         else
         {
            return STATE_UNKNOWN;
         }
      }
      inline int getSourceType(int srcIdx)
      {
         ::std::map<int, SrcDetails>::iterator itr;
         itr = SrcMapState.find(srcIdx);
         if (itr != SrcMapState.end())
         {
            return itr->second.sourceType;
         }
         else
         {
            return SOURCE_MAIN;
         }
      }

   private:
      SrcMap()
      {
         initMap();
      }
      void initMap()
      {
         SrcMapID[TUNER_FM_STR] = SRC_TUNER_FM;
         SrcMapID[TUNER_AM_STR] = SRC_TUNER_AM;
         SrcMapID[MEDIA_PLAYER_STR] = SRC_MEDIA_PLAYER;
         SrcMapID[TUNER_DAB_STR] = SRC_DAB;
         SrcMapID[TUNER_TA_FM_STR] = SRC_TUNER_TA_FM;
         SrcMapID[TUNER_TA_DAB_STR] = SRC_TUNER_TA_DAB;
         SrcMapID[TUNER_XM_STR] = SRC_TUNER_XM;
         SrcMapID[TUNER_WX_STR] = SRC_TUNER_WX;
         SrcMapID[MEDIA_AUX_STR] = SRC_MEDIA_AUX;
         SrcMapID[MEDIA_CDDA_STR] = SRC_MEDIA_CDDA;
         SrcMapID[PHONE_BTAUDIO_STR] = SRC_PHONE_BTAUDIO;
         SrcMapID[PHONE_STR] = SRC_PHONE;
         SrcMapID[PHONE_OUTBAND_RING_STR] = SRC_PHONE_OUTBAND_RING;
         SrcMapID[PHONE_INBAND_RING_STR] = SRC_PHONE_INBAND_RING;
         SrcMapID[PHONE_SPEECHRECOGNITION_STR] = SRC_PHONE_SPEECHRECOGNITION;
         SrcMapID[INTERCOM] = SRC_INTERCOM;
         SrcMapID[SMS_SPEECH_STR] = SRC_SMS_SPEECH;
         SrcMapID[SPI_ENTERTAIN_STR] = SRC_SPI_ENTERTAIN;
         SrcMapID[SPI_INFO_STR] = SRC_SPI_INFO;
         SrcMapID[SPI_PHONE_STR] = SRC_SPI_PHONE;
         SrcMapID[SPI_SPEECHRECOGNITION_STR] = SRC_SPI_SPEECHRECOGNITION;
         SrcMapID[SPI_ALERT_STR] = SRC_SPI_ALERT;
         SrcMapID[TCU_ECALL_STR] = SRC_TCU_ECALL;
         SrcMapID[TCU_SERVICE_CALL_STR] = SRC_TCU_SERVICE_CALL;
         SrcMapID[SDS_SPEECHRECOGNITION_STR] = SRC_SDS_SPEECHRECOGNITION;
         SrcMapID[NAVI_SPEECH_STR] = SRC_NAVI_SPEECH;
         SrcMapID[SXM_TTS_STR] = SRC_SXM_TTS;
         SrcMapID[SXM_NEWS_STR] = SRC_SXM_NEWS;
         SrcMapID[TCU_TTS_STR] = SRC_TCU_TTS;
         SrcMapID[IPA_TTS_STR] = SRC_IPA_TTS;
         SrcMapID[INTERNET_APPS_STR] = SRC_INTERNET_APPS;
         SrcMapID[PHONE_ECALL_STR] = SRC_PHONE_ECALL;
         SrcMapID[TUNER_DRM_STR] = SRC_TUNER_DRM;
         SrcMapID[TUNER_TI_AM_STR] = SRC_TUNER_TI_AM;
         SrcMapID[DTV_STR] = SRC_DTV;
         SrcMapID[USB_VIDEO_STR] = SRC_USB_VIDEO;
         SrcMapID[MEDIA_BLURAY_STR] = SRC_MEDIA_BLURAY;
         SrcMapID[RSE_IN_STR] = SRC_REAR;
         SrcMapID[WEB_ENTERTAIN_STR] = SRC_WEB_ENTERTAIN;
         SrcMapID[NAVI_BY_SDS_STR] = SRC_NAVI_BY_SDS;
         SrcMapID[SPI_VR_STEREO_STR] = SRC_SPI_VR_STEREO;
         SrcMapID[SPI_ML_INFO_STR] = SRC_SPI_ML_INFO;
         SrcMapID[EXT_NAVI_STR] = SRC_EXT_NAVI;
         SrcMapID[EXT_LVDS_MEDIA] = SRC_EXT_LVDS_MEDIA;
         SrcMapID[WEATHER_ALERT_STR] = SRC_WEATHER_ALERT;
         SrcMapID[CMR_USB1_VIDEO_STR] = SRC_CMR1_USB1_VIDEO;
         SrcMapID[CMR_USB2_VIDEO_STR] = SRC_CMR1_USB2_VIDEO;
         SrcMapID[CMR_USB1_AUDIO_STR] = SRC_CMR1_USB1_AUDIO;
         SrcMapID[CMR_USB2_AUDIO_STR] = SRC_CMR1_USB2_AUDIO;

         //Audio sources INF4CV starts
         SrcMapID[MIC_PRIVATE_STR] = SRC_MIC1_ANNOUNCEMENT;
         SrcMapID[AVB_MIC2_STR] = SRC_MIC2_ANNOUNCEMENT;
         SrcMapID[AVB_MIC3_STR] = SRC_MIC3_ANNOUNCEMENT;

         //Audio sources INF4CV starts

         SrcMapID[CAMERAPORT1_CAM1_STR]        = SRC_CAMERAPORT1_CAM1;
         SrcMapID[CAMERAPORT1_CAM2_STR]        = SRC_CAMERAPORT1_CAM2;
         SrcMapID[CAMERAPORT1_CAM3_STR]        = SRC_CAMERAPORT1_CAM3;
         SrcMapID[CAMERAPORT1_CAM4_STR]        = SRC_CAMERAPORT1_CAM4;
         SrcMapID[CAMERAPORT1_IPCAM_STR]       = SRC_CAMERAPORT1_IPCAM;
         SrcMapID[CAMERAPORT1_SPLITSCREEN_STR] = SRC_CAMERAPORT1_SPLITSCREEN;
         SrcMapID[CAMERAPORT1_USB_VIDEO_STR]   = SRC_CAMERAPORT1_USB_VIDEO;
         SrcMapID[CAMERAPORT1_HDMI_STR]        = SRC_CAMERAPORT1_HDMI;
         SrcMapID[CAMERAPORT1_USB_AUDIO_STR]   = SRC_CAMERAPORT1_USB_AUDIO;

         SrcMapID[CAMERAPORT2_CAM1_STR]        = SRC_CAMERAPORT2_CAM1;
         SrcMapID[CAMERAPORT2_CAM2_STR]        = SRC_CAMERAPORT2_CAM2;
         SrcMapID[CAMERAPORT2_CAM3_STR]        = SRC_CAMERAPORT2_CAM3;
         SrcMapID[CAMERAPORT2_CAM4_STR]        = SRC_CAMERAPORT2_CAM4;
         SrcMapID[CAMERAPORT2_IPCAM_STR]       = SRC_CAMERAPORT2_IPCAM;
         SrcMapID[CAMERAPORT2_SPLITSCREEN_STR] = SRC_CAMERAPORT2_SPLITSCREEN;
         SrcMapID[CAMERAPORT2_USB_VIDEO_STR]   = SRC_CAMERAPORT2_USB_VIDEO;
         SrcMapID[CAMERAPORT2_HDMI_STR]        = SRC_CAMERAPORT2_HDMI;

         SrcMapID[CAMERAPORT3_CAM1_STR]        = SRC_CAMERAPORT3_CAM1;
         SrcMapID[CAMERAPORT3_CAM2_STR]        = SRC_CAMERAPORT3_CAM2;
         SrcMapID[CAMERAPORT3_CAM3_STR]        = SRC_CAMERAPORT3_CAM3;
         SrcMapID[CAMERAPORT3_CAM4_STR]        = SRC_CAMERAPORT3_CAM4;
         SrcMapID[CAMERAPORT3_IPCAM_STR]       = SRC_CAMERAPORT3_IPCAM;
         SrcMapID[CAMERAPORT3_SPLITSCREEN_STR] = SRC_CAMERAPORT3_SPLITSCREEN;
         SrcMapID[CAMERAPORT3_USB_VIDEO_STR]   = SRC_CAMERAPORT3_USB_VIDEO;
         SrcMapID[CAMERAPORT3_HDMI_STR]        = SRC_CAMERAPORT3_HDMI;

         SrcMapID[CAMERAPORT4_CAM1_STR]        = SRC_CAMERAPORT4_CAM1;
         SrcMapID[CAMERAPORT4_CAM2_STR]        = SRC_CAMERAPORT4_CAM2;
         SrcMapID[CAMERAPORT4_CAM3_STR]        = SRC_CAMERAPORT4_CAM3;
         SrcMapID[CAMERAPORT4_CAM4_STR]        = SRC_CAMERAPORT4_CAM4;
         SrcMapID[CAMERAPORT4_IPCAM_STR]       = SRC_CAMERAPORT4_IPCAM;
         SrcMapID[CAMERAPORT4_SPLITSCREEN_STR] = SRC_CAMERAPORT4_SPLITSCREEN;
         SrcMapID[CAMERAPORT4_USB_VIDEO_STR]   = SRC_CAMERAPORT4_USB_VIDEO;
         SrcMapID[CAMERAPORT4_HDMI_STR]        = SRC_CAMERAPORT4_HDMI;
         //Audio sources INF4CV ends

         SrcMapState[SRC_TUNER_FM] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_TUNER_AM] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_MEDIA_PLAYER] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_DAB] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_TUNER_TA_FM] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_TUNER_TA_DAB] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_TUNER_XM] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_TUNER_WX] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_MEDIA_AUX] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_MEDIA_CDDA] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_PHONE_BTAUDIO] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_PHONE] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_PHONE_OUTBAND_RING] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_PHONE_INBAND_RING] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_PHONE_SPEECHRECOGNITION] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_SMS_SPEECH] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_SPI_ENTERTAIN] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_SPI_INFO] = SrcDetails(STATE_CONNECTED, SOURCE_MIX);
         SrcMapState[SRC_SPI_PHONE] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_SPI_SPEECHRECOGNITION] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_SPI_ALERT] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_TCU_ECALL] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_TCU_SERVICE_CALL] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_SDS_SPEECHRECOGNITION] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_NAVI_SPEECH] = SrcDetails(STATE_CONNECTED, SOURCE_MIX);
         SrcMapState[SRC_SXM_TTS] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_SXM_NEWS] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_TCU_TTS] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_IPA_TTS] = SrcDetails(STATE_CONNECTED, SOURCE_MIX);
         SrcMapState[SRC_INTERNET_APPS] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_PHONE_ECALL] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_TUNER_DRM] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_TUNER_TI_AM] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_DTV] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_USB_VIDEO] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_MEDIA_BLURAY] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_REAR] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_WEB_ENTERTAIN] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_NAVI_BY_SDS] = SrcDetails(STATE_CONNECTED, SOURCE_MIX);
         SrcMapState[SRC_SPI_VR_STEREO] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_SPI_ML_INFO] = SrcDetails(STATE_CONNECTED, SOURCE_MIX);
         SrcMapState[SRC_EXT_NAVI] = SrcDetails(STATE_CONNECTED, SOURCE_MIX);
         SrcMapState[SRC_EXT_LVDS_MEDIA] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_INTERCOM] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_WEATHER_ALERT] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_CMR1_USB1_VIDEO] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CMR1_USB2_VIDEO] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CMR1_USB1_AUDIO] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CMR1_USB2_AUDIO] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);

         //Audio sources INF4CV state starts
         SrcMapState[SRC_MIC1_ANNOUNCEMENT] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_MIC2_ANNOUNCEMENT] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);
         SrcMapState[SRC_MIC3_ANNOUNCEMENT] = SrcDetails(STATE_CONNECTED, SOURCE_ANNOUNCEMENT);

         //Audio sources INF4CV state starts
         SrcMapState[SRC_CAMERAPORT1_CAM1] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT1_CAM2] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT1_CAM3] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT1_CAM4] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT1_IPCAM] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT1_SPLITSCREEN] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT1_USB_VIDEO] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT1_HDMI] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT1_USB_AUDIO] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);

         SrcMapState[SRC_CAMERAPORT2_CAM1] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT2_CAM2] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT2_CAM3] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT2_CAM4] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT2_IPCAM] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT2_SPLITSCREEN] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT2_USB_VIDEO] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT2_HDMI] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);

         SrcMapState[SRC_CAMERAPORT3_CAM1] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT3_CAM2] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT3_CAM3] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT3_CAM4] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT3_IPCAM] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT3_SPLITSCREEN] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT3_USB_VIDEO] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT3_HDMI] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);

         SrcMapState[SRC_CAMERAPORT4_CAM1] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT4_CAM2] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT4_CAM3] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT4_CAM4] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT4_IPCAM] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT4_SPLITSCREEN] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT4_USB_VIDEO] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         SrcMapState[SRC_CAMERAPORT4_HDMI] = SrcDetails(STATE_CONNECTED, SOURCE_MAIN);
         //Audio sources INF4CV state ends
      }
};


class Source : public hmibase::apphmi_master::audio::Resource
{
   public:
      Source(std::string sName);
      ~Source();

      inline int GetIndex() const
      {
         return m_Index;
      }
      inline int GetDeviceId() const
      {
         return m_DeviceId;
      }
      inline int GetResponseState() const
      {
         return m_ConnResponseState;
      }
      inline int GetType() const
      {
         return m_Type;
      }
      inline bool IsSourceValid()
      {
         return (GetID() != SRC_INVALID);
      }
      inline void SetAvailabilityReason(int nAvailabilityReason)
      {
         m_AvaialabilityReason = nAvailabilityReason;
      }
      inline int GetAvailabilityReason()
      {
         return m_AvaialabilityReason;
      }

   private:
      int m_Index;
      int m_DeviceId;
      int m_ConnResponseState;
      int m_AvaialabilityReason;
      int m_Type;
};


}
}


}
#endif //Source_h
