/* ***************************************************************************************
* FILE:          SoundPropertiesSenderClient.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SoundPropertiesSenderClient.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

//#include "hall_std_if.h"

#include "AppHmi_MasterBase/AudioInterface/SoundPropertiesClient/SoundPropertiesSenderClient.h"
#include "AppHmi_MasterBase/AudioInterface/SoundController.h"
#include "AppHmi_MasterBase/AudioInterface/AudioControllerObjectManager.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_AUDIO_IF

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SoundPropertiesSenderClient.cpp.trc.h"
#endif

using namespace org::genivi::audiomanager::CommandInterface;

namespace hmibase {
namespace apphmi_master {
namespace audio {

SoundPropertiesSenderClient::SoundPropertiesSenderClient()
   : _commandIFProxy(CommandInterfaceProxy::createProxy("commandInterfacePort", *this))
{
   StartupSync::getInstance().registerPropertyRegistrationIF(this, _commandIFProxy->getPortName());
}


SoundPropertiesSenderClient::~SoundPropertiesSenderClient()
{
}


void SoundPropertiesSenderClient::initialize()
{
   AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->RegisterSoundPropertiesSenderClient(this);
}


void SoundPropertiesSenderClient::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onAvailable"));
   StartupSync::getInstance().onAvailable(proxy, stateChange);
}


void SoundPropertiesSenderClient::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onUnavailable"));
   StartupSync::getInstance().onUnavailable(proxy, stateChange);
}


void SoundPropertiesSenderClient::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (_commandIFProxy == proxy)
   {
      _actMap[_commandIFProxy->sendGetListMainSinkSoundPropertiesRequest(*this, DEFAULT_MAIN_SINK_ID)] = DEFAULT_MAIN_SINK_ID;
      _commandIFProxy->sendGetListSystemPropertiesRequest(*this);
   }
}


void SoundPropertiesSenderClient::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onUnavailable"));
}


void SoundPropertiesSenderClient::sendSetSystemProperty(uint16 propertyType, int16 value)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient sendSetSystemProperty"));
   SetSystemPropertyRequestPropertyStruct strSystemProperty(propertyType, value);
   _commandIFProxy->sendSetSystemPropertyRequest(*this, strSystemProperty);
}


void SoundPropertiesSenderClient::onSetSystemPropertyError(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SetSystemPropertyError >& /*error*/)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onSetSystemPropertyError"));
}


void SoundPropertiesSenderClient::onSetSystemPropertyResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SetSystemPropertyResponse >& /*reply*/)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onSetSystemPropertyResponse"));
}


void SoundPropertiesSenderClient::onSetMainSourceSoundPropertyError(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SetMainSourceSoundPropertyError >& /*error*/)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onSetMainSourceSoundPropertyError"));
}


void SoundPropertiesSenderClient::onSetMainSourceSoundPropertyResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/,
      const ::boost::shared_ptr< SetMainSourceSoundPropertyResponse >& /*reply*/)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onSetMainSourceSoundPropertyResponse"));
}


void SoundPropertiesSenderClient::onSetMainSinkSoundPropertyError(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SetMainSinkSoundPropertyError >& /*error*/)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onSetMainSinkSoundPropertyError"));
}


void SoundPropertiesSenderClient::onSetMainSinkSoundPropertyResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SetMainSinkSoundPropertyResponse >& /*reply*/)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onSetMainSinkSoundPropertyResponse"));
}


void SoundPropertiesSenderClient::sendSetVolumeRequest(uint16 sinkID, uint16 mode, int16 value)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient sendSetVolumeRequest"));
   _commandIFProxy->sendSetVolumeRequest(*this, sinkID, mode, value);
}


void SoundPropertiesSenderClient::sendSetSystemMuteRequest(uint16 sinkID, bool value)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient sendSetSystemMuteRequest"));
   SetMainSinkSoundPropertyRequestSoundPropertyStruct strSinkSoundProperty(static_cast<int16>(SYSTEM_MUTE), value);
   _commandIFProxy->sendSetMainSinkSoundPropertyRequest(*this, sinkID, strSinkSoundProperty);
}


void SoundPropertiesSenderClient::sendSetMainSinkSoundProperty(uint16 sinkID, uint16 soundProperty, uint16 value)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient sendSetMainSinkSoundProperty %d value %d ", soundProperty, value));
   SetMainSinkSoundPropertyRequestSoundPropertyStruct strSinkSoundProperty(soundProperty, value);
   _commandIFProxy->sendSetMainSinkSoundPropertyRequest(*this, sinkID, strSinkSoundProperty);
}


void SoundPropertiesSenderClient::sendgetListMainSinkSoundProperty(uint16 sinkID)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient sendgetListMainSinkSoundProperty"));
   _actMap[_commandIFProxy->sendGetListMainSinkSoundPropertiesRequest(*this, sinkID)] = sinkID;
}


void SoundPropertiesSenderClient::onGetListMainSinkSoundPropertiesError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesError >& /*error*/)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onGetListMainSinkSoundPropertiesError"));
}


void SoundPropertiesSenderClient::onGetListMainSinkSoundPropertiesResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponse >& reply)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onGetListMainSinkSoundPropertiesResponse"));
   if ((reply.get()) && (_actMap.count(reply->getAct()) > 0))
   {
      ::std::vector< GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct > vProp = reply->getListSoundProperties();
      ::std::vector< GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >::iterator itr;
      ::std::vector<bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundProperty> soundpropertylist;

      for (itr = vProp.begin(); itr != vProp.end(); ++itr)
      {
         AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->onSetSinkSoundProperty(itr->getElem1(), itr->getElem2());
         bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundProperty soundproperty(itr->getElem1(), itr->getElem2());
         soundpropertylist.push_back(soundproperty);
      }
      if (!soundpropertylist.empty())
      {
         boost::shared_ptr<ResourceController> pResourceController = AudioControllerObjectManager::getInstance().getResourceController<ResourceController>();
         int nSinkId = _actMap[reply->getAct()] ;
         if (pResourceController != NULL)
         {
            int nSinkIdx = pResourceController->GetIndexOnSinkID(nSinkId);
            ETG_TRACE_USR4_THR(("onSoundPropertyListUpdate  Dynamic sink ID %d", nSinkIdx));
            AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->onMainSinkSoundPropertiesListUpdate(soundpropertylist, nSinkIdx);
            AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->onSoundPropertyListUpdate(nSinkIdx);
         }
      }
      _actMap.erase(reply->getAct()); //remove the stored acknowledgement entry from actMap
   }
}


void SoundPropertiesSenderClient::sendgetListSystemProperty()
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient sendgetListSystemProperty"));
   _commandIFProxy->sendGetListSystemPropertiesRequest(*this);
}


void SoundPropertiesSenderClient::onGetListSystemPropertiesError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr<org::genivi::audiomanager::CommandInterface:: GetListSystemPropertiesError >& /*error*/)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onGetListSystemPropertiesError"));
}


void SoundPropertiesSenderClient::onGetListSystemPropertiesResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponse >& reply)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onGetListSystemPropertiesResponse"));
   if (reply.get())
   {
      ::std::vector<GetListSystemPropertiesResponseListSystemPropertiesStruct>::const_iterator itr = reply->getListSystemProperties().begin();
      ::std::vector<bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemProperty> systempropertylist;
      for (; itr != reply->getListSystemProperties().end(); itr++)
      {
         if (itr->getElem1() == SYP_USER_MUTE_STATUS)
         {
            AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->onUserMuteStateUpdate(itr->getElem2());
         }
         bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemProperty systemproperty(itr->getElem1(), itr->getElem2());
         systempropertylist.push_back(systemproperty);
      }
      if (!systempropertylist.empty())
      {
         AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->onSystemPropertiesListUpdate(systempropertylist);
      }
   }
}


void SoundPropertiesSenderClient::onSetVolumeError(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SetVolumeError >& /*error*/)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onSetVolumeError"));
}


void SoundPropertiesSenderClient::onSetVolumeResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SetVolumeResponse >& /*reply*/)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onSetVolumeResponse"));
}


void SoundPropertiesSenderClient::sendSetSinkMuteStateRequest(uint16 sinkID, uint16 muteState)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient sendSetSinkMuteStateRequest"));
   _commandIFProxy->sendSetSinkMuteStateRequest(*this, sinkID, muteState);
}


void SoundPropertiesSenderClient::onSetSinkMuteStateError(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SetSinkMuteStateError >& /*error*/)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onSetSinkMuteStateError"));
}


void SoundPropertiesSenderClient::onSetSinkMuteStateResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SetSinkMuteStateResponse >& /*reply*/)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesSenderClient onSetSinkMuteStateResponse"));
}


}
}


}
