/* ***************************************************************************************
* FILE:          SoundPropertiesReceiverClient.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SoundPropertiesReceiverClient.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

//#include "hall_std_if.h"

#include "AppHmi_MasterBase/AudioInterface/SoundPropertiesClient/SoundPropertiesReceiverClient.h"
#include "AppHmi_MasterBase/AudioInterface/SoundController.h"
#include "AppHmi_MasterBase/AudioInterface/AudioControllerObjectManager.h"
#include "AppHmi_MasterBase/AudioInterface/Source.h"
#include "AppHmi_MasterBase/AudioInterface/Sink.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"


#include "hmibase/util/Macros.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_AUDIO_IF
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SoundPropertiesReceiverClient.cpp.trc.h"
#endif


using namespace ::org::genivi::audiomanager::CommandInterface;

namespace hmibase {
namespace apphmi_master {
namespace audio {

SoundPropertiesReceiverClient::SoundPropertiesReceiverClient()
   : _commandIFProxy(CommandInterfaceProxy::createProxy("commandInterfacePort", *this)),
     _commandIFProxy_SystemPropertyChanged_RegId(0),
     _commandIFProxy_MainSourceSoundPropertyChanged_RegId(0),
     _commandIFProxy_MainSinkSoundPropertyChanged_RegId(0),
     _commandIFProxy_VolumeChanged_RegId(0),
     _commandIFProxy_SinkMuteStateChanged_RegId(0)
{
   StartupSync::getInstance().registerPropertyRegistrationIF(this, _commandIFProxy->getPortName());
}


SoundPropertiesReceiverClient::~SoundPropertiesReceiverClient()
{
}


// initialize after constructor
void SoundPropertiesReceiverClient::initialize()
{
}


void SoundPropertiesReceiverClient::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   StartupSync::getInstance().onAvailable(proxy, stateChange);
}


void SoundPropertiesReceiverClient::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   StartupSync::getInstance().onUnavailable(proxy, stateChange);
}


void SoundPropertiesReceiverClient::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (_commandIFProxy == proxy)
   {
      _commandIFProxy_SystemPropertyChanged_RegId = _commandIFProxy->sendSystemPropertyChangedRegister(*this);
      _commandIFProxy_MainSourceSoundPropertyChanged_RegId = _commandIFProxy->sendMainSourceSoundPropertyChangedRegister(*this);
      _commandIFProxy_MainSinkSoundPropertyChanged_RegId = _commandIFProxy->sendMainSinkSoundPropertyChangedRegister(*this);
      _commandIFProxy_VolumeChanged_RegId = _commandIFProxy->sendVolumeChangedRegister(*this);
      _commandIFProxy_SinkMuteStateChanged_RegId = _commandIFProxy->sendSinkMuteStateChangedRegister(*this);
   }
}


void SoundPropertiesReceiverClient::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR4_THR(("SoundPropertiesReceiverClient onUnavailable"));
}


void SoundPropertiesReceiverClient::onSystemPropertyChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SystemPropertyChangedSignal >& sig)
{
   ETG_TRACE_USR4_THR(("AudioSoundClient onSystemPropertyChanged"));
   if (sig->getSystemProperty().getElem1() == SYP_USER_MUTE_STATUS)
   {
      AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->onUserMuteStateUpdate(sig->getSystemProperty().getElem2());
   }
   AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->onSystemPropertyUpdate(sig->getSystemProperty().getElem1(), sig->getSystemProperty().getElem2());
}


void SoundPropertiesReceiverClient::onSystemPropertyChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SystemPropertyChangedError >& /*error*/)
{
   ETG_TRACE_USR4_THR(("AudioSoundClient onSystemPropertyChangedError"));
}


void SoundPropertiesReceiverClient::onGetListMainSourceSoundPropertiesError(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/,
      const ::boost::shared_ptr< GetListMainSourceSoundPropertiesError >& /*error*/)
{
   ETG_TRACE_USR4_THR(("AudioSoundClient onGetListMainSourceSoundPropertiesError"));
}


void SoundPropertiesReceiverClient::onGetListMainSourceSoundPropertiesResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/,
      const ::boost::shared_ptr< GetListMainSourceSoundPropertiesResponse >& /*reply*/)
{
   ETG_TRACE_USR4_THR(("AudioSoundClient onGetListMainSourceSoundPropertiesResponse"));
}


void SoundPropertiesReceiverClient::onMainSourceSoundPropertyChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< MainSourceSoundPropertyChangedSignal >& sig)
{
   ETG_TRACE_USR4_THR(("AudioSoundClient onMainSourceSoundPropertyChanged"));
   ETG_TRACE_USR4_THR(("AudioSoundClient onMainSourceSoundPropertyChanged sourceId %d", sig->getSourceID()));
   AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->setSourceSoundProperty(sig->getSoundProperty().getElem1(), sig->getSoundProperty().getElem2());
}


void SoundPropertiesReceiverClient::onMainSourceSoundPropertyChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< MainSourceSoundPropertyChangedError >& /*error*/)
{
   ETG_TRACE_USR4_THR(("AudioSoundClient onMainSourceSoundPropertyChangedError"));
}


void SoundPropertiesReceiverClient::onMainSinkSoundPropertyChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/,
      const ::boost::shared_ptr< MainSinkSoundPropertyChangedSignal >& sig)
{
   ETG_TRACE_USR4_THR(("AudioSoundClient onMainSinkSoundPropertyChanged sinkId %d", sig->getSinkID()));
   AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->onSetSinkSoundProperty(sig->getSoundProperty().getElem1(), sig->getSoundProperty().getElem2());
   AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->onMainSinkSoundPropertyUpdate(sig->getSoundProperty().getElem1(), sig->getSoundProperty().getElem2(), sig->getSinkID());
}


void SoundPropertiesReceiverClient::onMainSinkSoundPropertyChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/,
      const ::boost::shared_ptr< MainSinkSoundPropertyChangedError >& /*error*/)
{
   ETG_TRACE_USR4_THR(("AudioSoundClient onMainSinkSoundPropertyChangedError"));
}


void SoundPropertiesReceiverClient::onVolumeChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< VolumeChangedSignal >& sig)
{
   ETG_TRACE_USR4_THR(("AudioSoundClient onVolumeChanged"));
   AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->onVolumeValueChange(sig->getSinkID(), sig->getVolume());
}


void SoundPropertiesReceiverClient::onVolumeChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< VolumeChangedError >& /*error*/)
{
   ETG_TRACE_USR4_THR(("AudioSoundClient onVolumeChangedError"));
}


void SoundPropertiesReceiverClient::onSinkMuteStateChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SinkMuteStateChangedSignal >& sig)
{
   ETG_TRACE_USR4_THR(("AudioSoundClient onSinkMuteStateChanged"));
   AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->onSinkMuteStateChange(sig->getSinkID(), sig->getMuteState());
}


void SoundPropertiesReceiverClient::onSinkMuteStateChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& /*proxy*/, const ::boost::shared_ptr< SinkMuteStateChangedError >& /*error*/)
{
   ETG_TRACE_USR4_THR(("AudioSoundClient onSinkMuteStateChangedError"));
}


}
}


}
