/* ***************************************************************************************
* FILE:          SoundController.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SoundController.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef SoundController_h
#define SoundController_h

#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include <map>
#include <vector>
#include <stdint.h>
#include "AppHmi_MasterBase/AudioInterface/SinkMuteStateObserver.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesStub.h"

namespace hmibase {
namespace services {
namespace audio {
class HmiSoundProperties;
}


}
}


namespace hmibase {
namespace apphmi_master {
namespace audio {

class SoundPropertiesSenderClient;

class SoundController
{
   public:
      SoundController();
      virtual ~SoundController();

      inline void RegisterSoundPropertiesSenderClient(SoundPropertiesSenderClient* pSoundPropertiesSenderClient)
      {
         m_pSoundPropertiesSenderClient = pSoundPropertiesSenderClient;
      }

      inline void RegisterHmiSoundProperties(hmibase::services::audio::HmiSoundProperties* pHmiSoundProperties)
      {
         m_pHmiSoundProperties = pHmiSoundProperties;
      }
      inline bool getUserMuteStatus()
      {
         return m_bUserMuteStatus;
      }
      inline bool getAudioOffMuteStatus()
      {
         return m_bAudioOffMuteStatus;
      }
      void processLeftEncoder(int nSteps, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);
      void requestUserMuteState(bool bMuteState, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);
      void requestAudioOffMuteState(bool bMuteState, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);
      virtual void onSinkMuteStateChange(int nSinkId, int nMuteState);
      virtual bool onVolumeValueChange(int nSinkId, int nVolume);
      virtual void onUserMuteStateUpdate(bool);
      void requestBeep(int nBeepType);
      void setSourceSoundProperty(int nPropertyType, int nValue);
      void onSetSinkSoundProperty(int nPropertyType, int nValue);
      int getSoundProperty(enSoundPropertyType nPropertyType);
      virtual bool isBeepEnabled(int nBeepType);
      void setHmiStartupMute(bool bMute);
      void setSystemMute(bool bMute, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);
      void registerMuteStateUpdate(SinkMuteStateObserver* pObserver);
      void deRegisterMuteStateUpdate(SinkMuteStateObserver* pObserver);
      void sendAudioOffMuteStateUpdate(bool bMuteState);
      void sendUserMuteStateUpdate(bool bMuteState);
      void setMainSinkSoundProperty(enSoundPropertyType nPropertyType, int nValue, uint16_t nSinkId);
      void requestMainSinkSoundProperty(uint16_t nSinkId, uint16_t nPropertyType, int nValue);
      void requestSystemProperty(uint16_t nPropertyType, int nValue);
      void requestSystemPropertiesList();
      void requestMainSinkSoundPropertiesList(uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);
      bool requestUserMuteStatus(uint16_t nSinkId);

      void onMainSinkSoundPropertyUpdate(int nPropertyType, int nValue, uint16_t nSinkId);
      void onSystemPropertyUpdate(int nPropertyType, int nValue);
      void onSystemPropertiesListUpdate(::std::vector<bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemProperty> systempropertylist);
      void onMainSinkSoundPropertiesListUpdate(::std::vector<bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundProperty>soundpropertylist, int SinkId);

      virtual void onSoundPropertyListUpdate(int nSinkId);
      int getSoundPropertySink(enSoundPropertyType nPropertyType, int nSinkID);
      void onSinkMuteStateChangeUpdateMute(int nSinkId, int nMuteState);

   private:

      SoundPropertiesSenderClient* m_pSoundPropertiesSenderClient;
      hmibase::services::audio::HmiSoundProperties* m_pHmiSoundProperties;

      std::map<int, int> m_mainSinkSoundProperties;
      std::map<int, int> m_mainSourceSoundProperties;
      std::map< int, std::map<int, int> > m_mainSinkSoundPropertiesList_sink;

      ::std::vector< SinkMuteStateObserver* > _pObservers;

      bool m_bUserMuteStatus;
      bool m_bAudioOffMuteStatus;
      bool m_bIsUserMuteUpdateReceived;
      bool m_bIsAudioOffUpdateReceived;
};


} // namespace audio
} // namespace apphmi_master
} // namespace hmibase


#endif //SoundController_h
