/* ***************************************************************************************
* FILE:          Sink.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Sink.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef Sink_h
#define Sink_h

#include "AppHmi_MasterBase/AudioInterface/Resource.h"
#include <string>

namespace hmibase {
namespace apphmi_master {
namespace audio {

class Sink : public Resource
{
   public:
      Sink(std::string sName);
      ~Sink();

      inline void SetVolume(int nVolume)
      {
         m_Volume = nVolume;
      }

      inline int GetVolume() const
      {
         return m_Volume;
      }

      inline void SetMuteState(int nMuteState)
      {
         m_MuteState = nMuteState;
      }
      inline int GetMuteState() const
      {
         return m_MuteState;
      }

   private:
      int m_Volume;
      int m_MuteState;
};


}
}


}

#endif //Sink_h
