/* ***************************************************************************************
* FILE:          ResourceController.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ResourceController.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef ResourceController_h
#define ResourceController_h

#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChange.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"

namespace hmibase {
namespace apphmi_master {
namespace audio {

class Source;
class Sink;
class IHmiAudioServiceStubHandler;

class ResourceController
{
   public:
      ResourceController();
      virtual ~ResourceController();

      inline void RegisterCallbackObject(hmibase::apphmi_master::audio::IHmiAudioServiceStubHandler* pHmiAudioServiceStubHandler)
      {
         m_pHmiAudioServiceStubHandler = pHmiAudioServiceStubHandler;
      }

      void AddSink(int nSinkID, std::string sSinkName, int nSinkAvailability, int nVolume, int nMuteState, int nClassID);
      void RemoveSink(int nSinkID);
      void AddSource(int nSrcID, std::string sSrcName, int nSrcAvailability, int nSrcAvailabilityReason, int nClassID);
      void RemoveSource(int nSrcID);
      hmibase::apphmi_master::audio::Source* GetSourceOnIdx(int nSrcIndex, int nDevID = -1);
      hmibase::apphmi_master::audio::Source* GetSourceOnID(int nSrcID);
      hmibase::apphmi_master::audio::Sink* GetSinkOnID(int nSinkID);
      void UpdateSinkAvailability(int nSinkID, int nAvailability);
      void UpdateSourceAvailability(int nSourceID, int nAvailability, int nAvailabilityReason);
      virtual void SetGroupLastSrc(hmibase::apphmi_master::audio::Source* pSource);
      hmibase::apphmi_master::audio::Source* GetGroupLastSrc(int nGroupId);
      void GetGroupSrcList(int32 nGrpId, std::vector< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::sourceDetails >* pSrcList);

      /**
         intended to be overridden from derived class to get to know about a change of the sink if needed
      */
      virtual void OnUpdateSink(int sinkIdx)
      {
        (void) sinkIdx;
      };

      Source* GetAvailableSrc(int nGrpId);
      virtual void UpdateSourceListChange(int32 nSrcIndex);
      virtual void UpdateSourceAvailabilityChange(int32 nSrcIndex, int32 nSubSrcId, int32 nAvailability, int32 nAvailabilityReason);
      void mapSinkIdx(uint16_t nSinkIndex);
      uint16_t GetIndexOnSinkID(int nSinkID);
      Sink* GetSinkOnIdx();
   private:
      void removeGroupLastSrc(const hmibase::apphmi_master::audio::Source* pSource);
      uint16_t mapSinkName(const std::string& nSinkName);

      hmibase::apphmi_master::audio::IHmiAudioServiceStubHandler* m_pHmiAudioServiceStubHandler;
      ::std::map<int, hmibase::apphmi_master::audio::Source*> m_SrcList;
      ::std::map<int, hmibase::apphmi_master::audio::Sink*> m_SinkList;

      std::string m_sink_name;

      hmibase::apphmi_master::audio::Source* aGroupLastSrc[GROUP_COUNT];
};


}
}


}
#endif //ResourceController_h
