/* ***************************************************************************************
* FILE:          IHmiAudioServiceStubHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IHmiAudioServiceStubHandler.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMI_APPMASTER_IHMIAUDIOSERVICESTUBHANDLER_H
#define HMI_APPMASTER_IHMIAUDIOSERVICESTUBHANDLER_H

#include "asf/core/Types.h"
#include <vector>
#include "AudioDefines.h"

namespace hmibase {
namespace apphmi_master {
namespace audio {
// tunnel to hmi audio service
struct stSourceInfo
{
   uint32 srcId;
   uint32 deviceId;
   uint32 connectionState;
   int16_t sinkId;

   stSourceInfo() : srcId(0), deviceId(0), connectionState(0), sinkId(DEFAULT_MAIN_SINK_ID)
   {
   }

   stSourceInfo(uint32 src, uint32 device, uint32 connection, int16_t sink) : srcId(src), deviceId(device), connectionState(connection), sinkId(sink)
   {
   }
};


class IHmiAudioServiceStubHandler
{
   public :
      virtual ~IHmiAudioServiceStubHandler() {};

      virtual void sendSetActiveSource(int32 nSourceId, int32 nSubSourceId, int32 nSinkId, uint32 connectionState) = 0;
      virtual void sendSourceActivatedRequest(int32 nSrcIndex, int32 nSinkId = DEFAULT_MAIN_SINK_ID) = 0;
      virtual void sendSourceListUpdateRequest(int32 nGrpIndex) = 0;
      virtual void sendSetActiveSources(::std::vector<hmibase::apphmi_master::audio::stSourceInfo>& activeSources) = 0;
      virtual void sendSourceAvailabilityUpdateRequest(int32 nSrcIndex, int32 nSubSrcId, int32 nAvailability, int32 nAvailabilityReason) = 0;
};


}
}


}

#endif // HMI_APPMASTER_IHMIAUDIOSERVICESTUBHANDLER_H
