/* ***************************************************************************************
* FILE:          IAudioManagerHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IAudioManagerHandler.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMI_APPMASTER_IAUDIOMANAGERHANDLER_H
#define HMI_APPMASTER_IAUDIOMANAGERHANDLER_H

#include "asf/core/Types.h"

namespace hmibase {
namespace apphmi_master {
namespace audio {
// tunnel to CommandInterfaceProxy
class IAudioManagerHandler
{
   public:
      virtual ~IAudioManagerHandler() {};

      virtual int sendConnectRequest(uint16 u16SourceID, uint16 u16SinkID) = 0;
      virtual void sendDisconnectRequest(uint16 u16ConnectionID) = 0;
};


}
}


}
#endif // HMI_APPMASTER_IAUDIOMANAGERHANDLER_H
