/* ***************************************************************************************
* FILE:          HmiSoundProperties.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HmiSoundProperties.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HmiSoundProperties_h
#define HmiSoundProperties_h

#include "asf/core/Proxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesStub.h"

namespace hmibase {
namespace services {
namespace audio {

class HmiSoundProperties
   : public bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesStub
   , public asf::core::ServiceAvailableIF
{
   public:
      HmiSoundProperties();
      virtual ~HmiSoundProperties();

      virtual void initialize();

      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      virtual void onSetMuteStateRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SetMuteStateRequest >& request);
      virtual void onSetAudioStateRequest(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SetAudioStateRequest >& request);

      // SoundPropertiesStub

      virtual void onRequestMainSinkSoundPropertyListRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::masteraudioservice::SoundProperties::RequestMainSinkSoundPropertyListRequest >& request);
      virtual void onRequestSystemPropertyListRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::masteraudioservice::SoundProperties::RequestSystemPropertyListRequest >& request);
      virtual void onSetMainSinkSoundPropertyRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SetMainSinkSoundPropertyRequest >& request);
      virtual void onSetSystemPropertyRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SetSystemPropertyRequest >& request);

      void sendMainSinkSoundPropertyUpdate(int32 propertyType, int32 value, uint16 sinkId);
      void sendSystemPropertyUpdate(int32 propertyType, int32 value);

      void updateVolumeValue(int nVolume, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);
      void updateMuteState(bool bMuteState, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);
      void updateAudioState(bool bUserMuteStatus, bool bAudioOffMuteStatus, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);
      void updateSystemPropertyList(::std::vector< bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemProperty > systemproperty);
      void updateMainSinkSoundPropertyList(::std::vector<bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundProperty > soundproperty, int nSinkId);
      static HmiSoundProperties* getInstance();

   private:
      static HmiSoundProperties* _hmiSoundProperties ;
};


} //namespace audio
} //namespace apphmi_master
} //namespace hmibase

#endif //HmiSoundProperties_h
