/* ***************************************************************************************
* FILE:          HmiGeniviAudioClient.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HmiGeniviAudioClient.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HmiGeniviAudioClient_h
#define HmiGeniviAudioClient_h

#include "org/genivi/audiomanager/CommandInterfaceClientBase.h"
#include "AppHmi_MasterBase/AudioInterface/IAudioManagerHandler.h"
#include "AppBase/StartupSync/StartupSync.h"

namespace hmibase {
namespace apphmi_master {
namespace audio {

class HmiGeniviAudioClient : public asf::core::ServiceAvailableIF
   , public org::genivi::audiomanager::CommandInterface::CommandInterfaceClientBase
   , public hmibase::apphmi_master::audio::IAudioManagerHandler
   , public StartupSync::PropertyRegistrationIF
{
   public:
      HmiGeniviAudioClient();
      virtual ~HmiGeniviAudioClient();

      virtual void initialize();

      // ServiceAvailableIF
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // StartupSync::PropertyRegistrationIF
      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // ConnectCallbackIF
      virtual void onConnectError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::ConnectError >& error);
      virtual void onConnectResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::ConnectResponse >& reply);

      // DisconnectCallbackIF
      virtual void onDisconnectError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::DisconnectError >& error);
      virtual void onDisconnectResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::DisconnectResponse >& reply);

      // GetListMainConnectionsCallbackIF
      virtual void onGetListMainConnectionsError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListMainConnectionsError >& error);
      virtual void onGetListMainConnectionsResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponse >& reply);

      // GetListMainSinksCallbackIF
      virtual void onGetListMainSinksError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListMainSinksError >& error);
      virtual void onGetListMainSinksResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListMainSinksResponse >& reply);

      // GetListMainSourcesCallbackIF
      virtual void onGetListMainSourcesError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListMainSourcesError >& error);
      virtual void onGetListMainSourcesResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponse >& reply);

      // MainConnectionStateChangedCallbackIF
      virtual void onMainConnectionStateChangedSignal(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::MainConnectionStateChangedSignal >& signal);
      virtual void onMainConnectionStateChangedError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::MainConnectionStateChangedError >& error);

      // NumberOfMainConnectionsChangedCallbackIF
      virtual void onNumberOfMainConnectionsChangedSignal(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::NumberOfMainConnectionsChangedSignal >& signal);
      virtual void onNumberOfMainConnectionsChangedError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::NumberOfMainConnectionsChangedError >& error);

      // SinkAddedCallbackIF
      virtual void onSinkAddedSignal(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SinkAddedSignal >& signal);
      virtual void onSinkAddedError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SinkAddedError >& error);

      // SinkAvailabilityChangedCallbackIF
      virtual void onSinkAvailabilityChangedSignal(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SinkAvailabilityChangedSignal >& signal);
      virtual void onSinkAvailabilityChangedError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SinkAvailabilityChangedError >& error);

      // SinkRemovedCallbackIF
      virtual void onSinkRemovedSignal(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SinkRemovedSignal >& signal);
      virtual void onSinkRemovedError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SinkRemovedError >& error);

      // SourceAddedCallbackIF
      virtual void onSourceAddedSignal(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SourceAddedSignal >& signal);
      virtual void onSourceAddedError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SourceAddedError >& error);

      // SourceAvailabilityChangedCallbackIF
      virtual void onSourceAvailabilityChangedSignal(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SourceAvailabilityChangedSignal >& signal);
      virtual void onSourceAvailabilityChangedError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SourceAvailabilityChangedError >& error);

      // SourceRemovedCallbackIF
      virtual void onSourceRemovedSignal(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SourceRemovedSignal >& signal);
      virtual void onSourceRemovedError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SourceRemovedError >& error);

      // Callback 'NewMainConnectionCallbackIF'
      virtual void onNewMainConnectionError(const ::boost::shared_ptr<  org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy  >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::NewMainConnectionError >& error);
      virtual void onNewMainConnectionSignal(const ::boost::shared_ptr<  org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy  >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::NewMainConnectionSignal >& signal);

      // IAudioManagerHandler
      int sendConnectRequest(uint16 u16SourceID, uint16 u16SinkID);
      void sendDisconnectRequest(uint16 ConnectionID);

   private:
      ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy > _CommandIFProxy;
      act_t _CommandIFProxy_NumberOfMainConnectionsChanged_RegId;
      act_t _CommandIFProxy_SinkAdded_RegId;
      act_t _CommandIFProxy_SinkRemoved_RegId;
      act_t _CommandIFProxy_SourceAdded_RegId;
      act_t _CommandIFProxy_SourceRemoved_RegId;
      act_t _CommandIFProxy_MainConnectionStateChanged_RegId;
      act_t _CommandIFProxy_SinkAvailabilityChanged_RegId;
      act_t _CommandIFProxy_SourceAvailabilityChanged_RegId;
      act_t _CommandIFProxy_NewMainConnection_RegId;
};


}
}


}


#endif //HmiGeniviAudioClient_h
