/* ***************************************************************************************
* FILE:          HmiAudioSourceChange.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HmiAudioSourceChange.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIAUDIOSOURCECHANGE_H
#define HMIAUDIOSOURCECHANGE_H

#include "boost/make_shared.hpp"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeStub.h"
#include "AppHmi_MasterBase/AudioInterface/IHmiAudioServiceStubHandler.h"
#include "AppHmi_MasterBase/AudioInterface/ConnectionController.h"
#include "AppHmi_MasterBase/AudioInterface/SoundController.h"
#include "AppHmi_MasterBase/AudioInterface/ResourceController.h"
#include "AppHmi_MasterBase/AudioInterface/SoundPropertiesClient/SoundPropertiesReceiverClient.h"
#include "AppHmi_MasterBase/AudioInterface/SoundPropertiesClient/SoundPropertiesSenderClient.h"


namespace hmibase {
namespace services {
namespace audio {
class HmiAudioSourceChange:
   public ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeStub
   , public hmibase::apphmi_master::audio::IHmiAudioServiceStubHandler
{
   public:
      HmiAudioSourceChange();
      ~HmiAudioSourceChange();

      void initialize(boost::shared_ptr<hmibase::apphmi_master::audio::ConnectionController> connectionController, boost::shared_ptr<hmibase::apphmi_master::audio::SoundController> soundController, boost::shared_ptr<hmibase::apphmi_master::audio::ResourceController> resourceController);

      // AudioSourceChangeStub
      virtual void onActivateSourceRequest(const boost::shared_ptr< bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActivateSourceRequest >& request);
      virtual void onDeactivateSourceRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::DeactivateSourceRequest >& request);
      virtual void onGetSourceListRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::GetSourceListRequest >& request);

      // IHmiAudioServiceStubHandler
      virtual void sendSourceActivatedRequest(int32 nSrcIndex, int32 nSinkId);
      virtual void sendSourceListUpdateRequest(int32 nGrpIndex);
      virtual void sendSourceAvailabilityUpdateRequest(int32 nSrcIndex, int32 nSubSrcId, int32 nAvailability, int32 nAvailabilityReason);
      virtual void sendSetActiveSource(int32 nSourceId, int32 nSubSourceId, int32 nSinkId, uint32 connectionState);
      virtual void sendSetActiveSources(::std::vector<hmibase::apphmi_master::audio::stSourceInfo>& activeSources);

   private:

      bool removeOldEntries(::std::vector<bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::sourceData>& activeSourceList);
      bool addNewEntries(::std::vector<bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::sourceData>& activeSourceList);

      hmibase::apphmi_master::audio::SoundPropertiesReceiverClient _soundPropsRecvClient;
      hmibase::apphmi_master::audio::SoundPropertiesSenderClient   _soundPropsSenderClient;
      ::std::vector<bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::sourceData> _activeSourceList;
};


}
}


}

#endif // HMI_APPMASTER_BASEAUDIOCLIENTHANDLER_H
