/* ***************************************************************************************
* FILE:          ConnectionController.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ConnectionController.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef ConnectionController_h
#define ConnectionController_h

#include <map>
#include "AudioDefines.h"

namespace hmibase {
namespace apphmi_master {
namespace audio {

class IAudioManagerHandler;
class IHmiAudioServiceStubHandler;
class Connection;
class Source;
class Sink;
struct stSourceInfo;


class ConnectionController
{
   public:
      ConnectionController();
      virtual ~ConnectionController();

      inline void RegisterCallbackObject(hmibase::apphmi_master::audio::IHmiAudioServiceStubHandler* pHmiAudioServiceStubHandler)
      {
         m_pHmiAudioServiceStubHandler = pHmiAudioServiceStubHandler;
      }

      inline void RegisterHmiGeniviAudioClient(hmibase::apphmi_master::audio::IAudioManagerHandler* pIAudioManagerHandler)
      {
         m_pIAudioManagerHandler = pIAudioManagerHandler;
      }

      void sendConnectRequest(Source* pSource, Sink* pSink);
      void sendDisconnectRequest(const Connection* pConnection);

      void mainConnectResponse(int nConnectionID, int nAct);
      void updateConnectionState(Connection* pConnection);
      void updateMainConnectionState(int nConnectionID, int nConnectionState);
      void mainConnectError();
      void createNewConnection(int nConnectionID);
      void startConnectionListUpdate();
      void addMainConnection(int& nConnID, int& nSrcID, int& nSinkID, int& nDelay, int& nState);
      void endConnectionListUpdate();
      Connection* getMainConnection(const Source* pSource, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);

      virtual bool sourceRequest(int nSrcIndex, int nDevId = -1, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);
      virtual void sourceDisconnect(int nSrcIndex, int nDevId = -1, uint16_t nSinkId = DEFAULT_MAIN_SINK_ID);
      virtual bool groupRequest(int nGrpIndex);
      void sendSourceActivationRequest(Source* pSource, Sink* pSink, int nState);
      virtual void sendSourceActivationMsgRequest(int nSrcIndex);
      virtual void actionOnNoSrc(int nGrpIndex);
      virtual void sendLastApplicationRequest();
      virtual void onNewActiveConnections() {};
      void updateActiveConnections();
      Connection* getActiveConnection(uint16_t nSinkId);

      inline void setStartUpAvailable()
      {
         m_bStartupAvailable = true;
      }
      inline bool getUserSourceAction()
      {
         return _userSourceAction;
      }
      inline void setUserSourceAction(bool userSourceAction)
      {
         _userSourceAction = userSourceAction;
      }

      virtual void evalApplicationStart(int grpIndex, hmibase::apphmi_master::audio::Source* src);

   protected:

      bool m_bStartupAvailable;
      bool m_bGroupRequestActive;
      bool _userSourceAction;

      hmibase::apphmi_master::audio::IAudioManagerHandler* m_pIAudioManagerHandler;
      hmibase::apphmi_master::audio::IHmiAudioServiceStubHandler* m_pHmiAudioServiceStubHandler;

      std::map<int, Connection*> m_ConnectionMap;
   private:
      int m_ConnectACT;
      Connection* m_pMainConnection;
      Source* m_pSourceConnect;
      Sink* m_pSinkConnect;
};


} // namespace audio
} // namespace apphmimaster
} // namespace hmibase


#endif //ConnectionController_h
